var tabla;

function init() {
  $("#zona_form").on("submit", function (e) {
    guardaryeditar(e);
  });

  $.post("../../controladores/zona.php?op=combo", function (data) {
    $("#Ccod_centroID").html(data);
  });
}

$(document).ready(function () {
  tabla = $("#zona_tabla")
    .dataTable({
      aProcessing: true,
      aServerSide: true,
      dom: "Bfrtip",
      buttons: ["copyHtml5", "excelHtml5", "csvHtml5"],
      ajax: {
        url: "../../controladores/zona.php?op=listar",
        type: "get",
        dataType: "json",
        error: function (e) {
          console.log(e.responseText);
        },
      },
      bDestroy: true,
      responsive: true,
      bInfo: true,
      iDisplayLength: 10,
      order: [[0, "asc"]],
      language: {
        sProcessing: "Procesando...",
        sLengthMenu: "Mostrar _MENU_ registros",
        sZeroRecords: "No se encontraron resultados",
        sEmptyTable: "Ningún dato disponible en esta tabla",
        sInfo:
          "Mostrando registros del _START_ al _END_ de un total de _TOTAL_ registros",
        sInfoEmpty: "Mostrando registros del 0 al 0 de un total de 0 registros",
        sInfoFiltered: "(filtrado de un total de _MAX_ registros)",
        sInfoPostFix: "",
        sSearch: "Buscar:",
        sUrl: "",
        sInfoThousands: ",",
        sLoadingRecords: "Cargando...",
        oPaginate: {
          sFirst: "Primero",
          sLast: "Último",
          sNext: "Siguiente",
          sPrevious: "Anterior",
        },
        oAria: {
          sSortAscending:
            ": Activar para ordenar la columna de manera ascendente",
          sSortDescending:
            ": Activar para ordenar la columna de manera descendente",
        },
      },
    })
    .DataTable();
});
function guardaryeditar(e) {
  e.preventDefault();
  var formData = new FormData($("#zona_form")[0]);
  $.ajax({
    url: "../../controladores/zona.php?op=guardaryeditar",
    type: "POST",
    data: formData,
    contentType: false,
    processData: false,
    success: function (datos) {
      $("#zona_form")[0].reset();
      $("#modalmtnzona").modal("hide");
      tabla.ajax.reload(function () {
        swal({
          title: "Sistema Modular QR",
          text: "Completado.",
          type: "success",
          confirmButtonClass: "btn-success",
        });
      });
    },
    error: function (xhr, ajaxOptions, thrownError) {
      console.log(xhr.responseText);
    },
  });
}

function editar(Ccod_zonaID) {
  $.post(
    "../../controladores/zona.php?op=mostrar",
    { Ccod_zonaID: Ccod_zonaID },
    function (data) {
      data = JSON.parse(data);
      $("#Ccod_zonaID").val(data.Ccod_zonaID);
      $("#Ccod_centroID").val(data.Ccod_centroID).trigger("change");
      $("#Ccod_zona").val(data.Ccod_zona);
      $("#Cdes_zona").val(data.Cdes_zona);
      $("#Cactivo").val(data.Cactivo);
    }
  );
  $("#mdltitulo").html("Editar Zona");
  $("#modalmtnzona").modal("show");
}

$(document).on("click", "#btnnuevo", function () {
  $("#zona_form")[0].reset();
  $("#Ccod_zonaID").val("");
  $("#mdltitulo").html("Nueva Zona");
  $("#modalmtnzona").modal("show");
});

init();
