var tabla;

function init() {
  // Configurar el evento de envío del formulario
  $("#usuario_form").on("submit", function (e) {
    guardaryeditar(e);
  });

  // Cargar los roles en el combo al iniciar
  $.post("../../controladores/usuario.php?op=combo", function (data) {
    $("#N_rolID").html(data);
  });

  // Inicializar la tabla
  listar();
}

function listar() {
  // Configuración de la tabla de usuarios con DataTables
  tabla = $("#usuario_tabla")
    .dataTable({
      aProcessing: true,
      aServerSide: true,
      dom: "Bfrtip",
      buttons: ["copyHtml5", "excelHtml5", "csvHtml5"],
      ajax: {
        url: "../../controladores/usuario.php?op=listar",
        type: "get",
        dataType: "json",
        error: function (e) {
          console.log(e.responseText);
        },
      },
      bDestroy: true,
      responsive: true,
      bInfo: true,
      iDisplayLength: 10,
      order: [[0, "asc"]],
      language: {
        sProcessing: "Procesando...",
        sLengthMenu: "Mostrar _MENU_ registros",
        sZeroRecords: "No se encontraron resultados",
        sEmptyTable: "Ningún dato disponible en esta tabla",
        sInfo:
          "Mostrando registros del _START_ al _END_ de un total de _TOTAL_ registros",
        sInfoEmpty: "Mostrando registros del 0 al 0 de un total de 0 registros",
        sInfoFiltered: "(filtrado de un total de _MAX_ registros)",
        sSearch: "Buscar:",
        oPaginate: {
          sFirst: "Primero",
          sLast: "Último",
          sNext: "Siguiente",
          sPrevious: "Anterior",
        },
      },
    })
    .DataTable();
}

function guardaryeditar(e) {
  e.preventDefault();
  var formData = new FormData($("#usuario_form")[0]);

  $.ajax({
    url: "../../controladores/usuario.php?op=guardaryeditar",
    type: "POST",
    data: formData,
    contentType: false,
    processData: false,
    success: function (datos) {
      $("#usuario_form")[0].reset();
      $("#modalmtnusuario").modal("hide");
      tabla.ajax.reload(function () {
        swal({
          title: "Sistema Modular QR",
          text: "Operación completada exitosamente.",
          type: "success",
          confirmButtonClass: "btn-success",
        });
      });
    },
    error: function (xhr, ajaxOptions, thrownError) {
      console.error("Error en la solicitud:", xhr.responseText);
      swal({
        title: "Error",
        text: "Ocurrió un error durante la operación. Por favor, intenta nuevamente.",
        type: "error",
        confirmButtonClass: "btn-danger",
      });
    },
  });
}

function editar(Ccod_usuID) {
  $.post(
    "../../controladores/usuario.php?op=mostrar",
    { Ccod_usuID: Ccod_usuID },
    function (data) {
      data = JSON.parse(data);
      $("#Ccod_usuID").val(data.Ccod_usuID);
      $("#Ccod_usu").val(data.Ccod_usu);
      $("#Nom_usu").val(data.Nom_usu);
      $("#Apell_usu").val(data.Apell_usu);
      $("#Correo_usu").val(data.Correo_usu);
      $("#Pass_usu").val(""); // Asegúrate de que el campo de la contraseña esté vacío al editar
      $("#Pass_usu").attr(
        "placeholder",
        "Dejar vacío si no desea cambiar la contraseña"
      ); // Placeholder para edición
      $("#N_rolID").val(data.N_rolID).trigger("change");
      $("#Cusuest").prop("checked", data.Cusuest == 1); // Ajusta el estado del checkbox
    }
  );
  $("#mdltitulo").html("Editar usuario");
  $("#modalmtnusuario").modal("show");
}

$(document).on("click", "#btnnuevo", function () {
  resetFormulario(); // Utiliza la función para resetear el formulario
  $("#mdltitulo").html("Nuevo usuario");
  $("#modalmtnusuario").modal("show");
});

function resetFormulario() {
  // Resetear el formulario
  $("#usuario_form")[0].reset();
  // Limpiar el valor del campo de contraseña y establecer un placeholder para nuevo registro
  $("#Pass_usu").val("");
  $("#Pass_usu").attr("placeholder", "Ingresa la contraseña del usuario"); // Placeholder para nuevo registro
  // Limpiar otros campos necesarios
  $("#Ccod_usuID").val("");
  $("#N_rolID").val("").trigger("change");
}

function togglePasswordVisibility() {
  var passwordInput = document.getElementById("Pass_usu");
  var icon = document.getElementById("togglePasswordIcon");

  if (passwordInput.type === "password") {
    passwordInput.type = "text";
    icon.classList.remove("glyphicon-eye-open");
    icon.classList.add("glyphicon-eye-close");
  } else {
    passwordInput.type = "password";
    icon.classList.remove("glyphicon-eye-close");
    icon.classList.add("glyphicon-eye-open");
  }
}

init();
