var tabla;

function init() {
  $("#tipoactivo_form").on("submit", function (e) {
    guardaryeditar(e);
  });

  listar();
}

function listar() {
  tabla = $("#tipoactivo_tabla").DataTable({
    aProcessing: true,
    aServerSide: true,
    dom: "Bfrtip",
    buttons: ["copyHtml5", "excelHtml5", "csvHtml5"],
    ajax: {
      url: baseURL + "controladores/tipoactivo.php?op=listar",
      type: "get",
      dataType: "json",
      error: function (e) {
        console.error(e.responseText);
      },
    },
    bDestroy: true,
    responsive: true,
    bInfo: true,
    iDisplayLength: 10,
    order: [[0, "asc"]],
    language: {
      sProcessing: "Procesando...",
      sLengthMenu: "Mostrar _MENU_ registros",
      sZeroRecords: "No se encontraron resultados",
      sEmptyTable: "Ningún dato disponible en esta tabla",
      sInfo:
        "Mostrando registros del _START_ al _END_ de un total de _TOTAL_ registros",
      sInfoEmpty: "Mostrando registros del 0 al 0 de un total de 0 registros",
      sInfoFiltered: "(filtrado de un total de _MAX_ registros)",
      sSearch: "Buscar:",
      oPaginate: {
        sFirst: "Primero",
        sLast: "Último",
        sNext: "Siguiente",
        sPrevious: "Anterior",
      },
    },
  });
}

function editar(Ccod_tipo_actID) {
  $.post(
    baseURL + "controladores/tipoactivo.php?op=mostrar",
    { Ccod_tipo_actID: Ccod_tipo_actID },
    function (data) {
      data = JSON.parse(data);
      $("#Ccod_tipo_actID").val(data.Ccod_tipo_actID);
      $("#Ccod_tipo_act").val(data.Ccod_tipo_act);
      $("#Cdes_tipo_act").val(data.Cdes_tipo_act);

      // Eliminar el atributo required al editar
      $("#Cruta_act").removeAttr("required");

      if (data.Cruta_act) {
        $("#pdf-name").text(data.Cruta_act.split("/").pop());
        $("#pdf-view")
          .attr("href", baseURL + data.Cruta_act)
          .show();
        $("#pdf-download")
          .attr("href", baseURL + data.Cruta_act)
          .show();
        $("#pdf-remove").show();
      } else {
        resetPDFView(); // Restablece el mostrador de PDF si no hay PDF seleccionado
      }

      $("#ventana_tipoactivo").modal("show");
    }
  );
  $("#mdltitulo").html("Editar Registro");
}

function eliminar(Ccod_tipo_actID) {
  $.post(
    baseURL + "controladores/tipoactivo.php?op=eliminar",
    { Ccod_tipo_actID: Ccod_tipo_actID },
    function (data) {
      tabla.ajax.reload();
      swal("Completado", "Operación realizada con éxito", "success");
    }
  );
}

function guardaryeditar(e) {
  e.preventDefault();
  var formData = new FormData($("#tipoactivo_form")[0]);

  // Mostrar el SweetAlert de carga antes de realizar la solicitud
  swal({
    title: "Cargando...",
    text: "Subiendo archivo, por favor espera.",
    icon: "info",
    buttons: false,
    closeOnClickOutside: false,
    closeOnEsc: false,
  });

  $.ajax({
    url: baseURL + "controladores/tipoactivo.php?op=guardaryeditar",
    type: "POST",
    data: formData,
    contentType: false,
    processData: false,
    success: function (datos) {
      // Cerrar el SweetAlert de carga
      swal.close();

      $("#tipoactivo_form")[0].reset();
      $("#ventana_tipoactivo").modal("hide");
      tabla.ajax.reload(function () {
        // Mostrar el SweetAlert de éxito
        swal("Completado", "Operación realizada con éxito", "success");
      });
    },
    error: function (xhr, ajaxOptions, thrownError) {
      // Cerrar el SweetAlert de carga en caso de error
      swal.close();
      console.error("Error al guardar: ", xhr.responseText);
    },
  });
}


function removePDF() {
  if (confirm("¿Estás seguro de que quieres eliminar el PDF actual?")) {
    $("#pdf-name").text("Ningún archivo seleccionado");
    $("#pdf-view").hide();
    $("#pdf-download").hide();
    $("#pdf-remove").hide();
    $("#Cruta_act").val(""); // Marca como eliminado en la interfaz
  }
}

function resetPDFView() {
  $("#pdf-name").text("Ningún archivo seleccionado");
  $("#pdf-date").text("");
  $("#pdf-view").hide();
  $("#pdf-download").hide();
  $("#pdf-remove").hide();
  $("#Cruta_act").attr("required", "required"); // Asegura que sea requerido en un nuevo registro
}

$(document).on("click", "#btnnuevo", function () {
  $("#mdltitulo").html("Nueva especificación");
  $("#ventana_tipoactivo").modal("show");
  $("#tipoactivo_form")[0].reset();
  $("#Ccod_tipo_actID").val("");
  resetPDFView(); // Restablece el mostrador de PDF al crear un nuevo registro
});

// Sincronización del input file con el mostrador de PDF
document.addEventListener("DOMContentLoaded", function () {
  const fileInput = document.getElementById("Cruta_act");
  const pdfName = document.getElementById("pdf-name");
  const pdfDate = document.getElementById("pdf-date");
  const pdfView = document.getElementById("pdf-view");
  const pdfDownload = document.getElementById("pdf-download");
  const pdfRemove = document.getElementById("pdf-remove");

  fileInput.addEventListener("change", function () {
    if (fileInput.files.length > 0) {
      const file = fileInput.files[0];
      const date = new Date().toLocaleString();

      // Mostrar nombre y fecha del archivo
      pdfName.textContent = file.name;
      pdfDate.textContent = date;

      // Configurar enlaces de vista y descarga
      const fileURL = URL.createObjectURL(file);
      pdfView.href = fileURL;
      pdfDownload.href = fileURL;
      pdfDownload.download = file.name;

      // Mostrar enlaces y botón de eliminar
      pdfView.style.display = "inline";
      pdfDownload.style.display = "inline";
      pdfRemove.style.display = "inline";
    } else {
      // Restablecer si no hay archivo seleccionado
      resetPDFView();
    }
  });

  // Función para eliminar el archivo seleccionado
  window.removePDF = function () {
    fileInput.value = ""; // Eliminar archivo del input
    resetPDFView(); // Restablecer la vista
  };
});

init();
