<?php
require_once("../../config/conexion.php");
require_once("../../config/config.php");


if (session_status() === PHP_SESSION_NONE) {
    session_start();
}


if (isset($_SESSION["Ccod_usu"])) {
?>

    <!DOCTYPE html>
    <html>

    <head>
        <meta charset="UTF-8">
        <meta name="viewport" content="width=device-width, initial-scale=1.0">
        <?php require_once("../head/head.php") ?>
        <title>Mantenimiento de tipo de activo</title>
        <script type="text/javascript">
            var baseURL = "<?= $base_url; ?>";
        </script>
    </head>

    <body class="with-side-menu">

        <?php require_once("../header/header.php") ?>
        <div class="mobile-menu-left-overlay"></div>
        <?php require_once("../nav/nav.php") ?>

        <div class="page-content">
            <div class="container-fluid">
                <header class="section-header">
                    <div class="tbl">
                        <div class="tbl-row">
                            <div class="tbl-cell">
                                <h3>Mantenimiento de tipo de activo</h3>
                                <h6>En esta ventana, podrás visualizar, registrar y editar los tipos de activos con sus correspondientes fichas de especificaciones técnicas.</h6>
                                <p></p>

                                <ol class="breadcrumb breadcrumb-simple">
                                    <li><a href="../home/home.php">Inicio</a></li>
                                    <li class="active">Mantenimiento y repositorio de fichas</li>

                                </ol>
                            </div>
                        </div>
                    </div>
                </header>
                <div class="box-typical box-typical-padding">
                    <table id="tipoactivo_tabla" class="display table table-bordered" cellspacing="0" width="100%">
                        <thead>
                            <tr>
                                <th>Código</th>
                                <th>Descripción</th>
                                <th>PDF</th>
                                <th>Acciones</th>
                            </tr>
                        </thead>
                        <tbody>
                        </tbody>
                    </table>

                    <button id="btnnuevo" type="button" class="btn btn-rounded btn-inline btn-primary">Nuevo Tipo de Activo</button>
                </div>
            </div><!--.container-fluid-->
        </div><!--.page-content-->

        <?php require_once("ventana_tipoactivo.php") ?>
        <?php require_once("../js/js.php") ?>

        <script type="text/javascript" src="mtnactivo.js"></script>

    </body>

    </html>

<?php
} else {
    header("Location:" . Conectar::ruta() . "index.php");
    exit;
}
?>