var tabla;

function init() {
  $("#material_form").on("submit", function (e) {
    guardaryeditar(e);
  });
}

$(document).ready(function () {
  tabla = $("#material_tabla")
    .dataTable({
      aProcessing: true, // Activamos el procesamiento del datatables
      aServerSide: true, // Paginación y filtrado realizados por el servidor
      dom: "Bfrtip", // Definimos los elementos del control de tabla
      buttons: ["copyHtml5", "excelHtml5", "csvHtml5"],
      ajax: {
        url: "../../controladores/material.php?op=listar",
        type: "get",
        dataType: "json",
        error: function (e) {
          console.log(e.responseText);
        },
      },
      bDestroy: true,
      responsive: true,
      bInfo: true,
      iDisplayLength: 10, // Por cada 10 registros hace una paginación
      order: [[0, "asc"]], // Ordenar (columna,orden)
      language: {
        sProcessing: "Procesando...",
        sLengthMenu: "Mostrar _MENU_ registros",
        sZeroRecords: "No se encontraron resultados",
        sEmptyTable: "Ningún dato disponible en esta tabla",
        sInfo:
          "Mostrando registros del _START_ al _END_ de un total de _TOTAL_ registros",
        sInfoEmpty: "Mostrando registros del 0 al 0 de un total de 0 registros",
        sInfoFiltered: "(filtrado de un total de _MAX_ registros)",
        sInfoPostFix: "",
        sSearch: "Buscar:",
        sUrl: "",
        sInfoThousands: ",",
        sLoadingRecords: "Cargando...",
        oPaginate: {
          sFirst: "Primero",
          sLast: "Último",
          sNext: "Siguiente",
          sPrevious: "Anterior",
        },
        oAria: {
          sSortAscending:
            ": Activar para ordenar la columna de manera ascendente",
          sSortDescending:
            ": Activar para ordenar la columna de manera descendente",
        },
      },
    })
    .DataTable();
});

function guardaryeditar(e) {
  e.preventDefault();
  var formData = new FormData($("#material_form")[0]);
  $.ajax({
    url: "../../controladores/material.php?op=guardaryeditar",
    type: "POST",
    data: formData,
    contentType: false,
    processData: false,
    success: function (datos) {
      $("#material_form")[0].reset();
      $("#modalmtnmat").modal("hide");
      tabla.ajax.reload(function () {
        swal({
          title: "Sistema Modular QR",
          text: "Completado.",
          type: "success",
          confirmButtonClass: "btn-success",
        });
      });
    },
    error: function (xhr, ajaxOptions, thrownError) {
      console.log(xhr.responseText);
    },
  });
}

function editar(Ccod_matID) {
  $.post(
    "../../controladores/material.php?op=mostrar",
    { Ccod_matID: Ccod_matID },
    function (data) {
      data = JSON.parse(data);
      $("#Ccod_matID").val(data.Ccod_matID); // Asegúrate de que el nombre coincide con el campo oculto del formulario
      $("#Ccod_mat").val(data.Ccod_mat);
      $("#Cdescrip").val(data.Cdescrip);
      $("#Cest_mat").val(data.Cest_mat);
    }
  );
  $("#mdltitulo").html("Editar Material");
  $("#modalmtnmat").modal("show");
}

$(document).on("click", "#btnnuevo", function () {
  $("#mdltitulo").html("Nuevo material");
  $("#modalmtnmat").modal("show");
  $("#material_form")[0].reset();
  $("#Ccod_matID").val(""); // Asegurarse de que el campo oculto esté vacío para la creación
});

init();
