<?php
require_once("../../config/config.php");
require_once("../../config/conexion.php");

// Asegúrate de que la sesión esté iniciada
if (session_status() === PHP_SESSION_NONE) {
    session_start();
}

// Verifica si el usuario ha iniciado sesión
if (isset($_SESSION["Ccod_usu"])) {
    $rol_id = $_SESSION["N_rolID"]; // Obtén el rol del usuario de la sesión
?>
    <!DOCTYPE html>
    <html>
    <?php require_once("../head/head.php") ?>
    <title>QRmodular</title>

    </head>

    <body class="with-side-menu">

        <?php require_once("../header/header.php") ?>

        <div class="mobile-menu-left-overlay"></div>
        <?php require_once("../nav/nav.php") ?>

        <div class="page-content">
            <div class="container-fluid">
                <h4>En esta ventana, podrás visualizar algunos graficos relacionados a los activos.<br>
                    (BETA)</h4>
                    <p></p>

                <div class="col-xl-12">
                    <div class="row">
                        <div class="col-sm-6">
                            <article class="statistic-box red">
                                <div>
                                    <div class="number" id="total-activos">0</div>
                                    <div class="caption">
                                        <div>Total de activos</div>
                                    </div>
                                </div>
                            </article>
                        </div><!--.col-->
                        <div class="col-sm-6">
                            <article class="statistic-box purple">
                                <div>
                                    <div class="number" id="activos-sin-cliente">0</div>
                                    <div class="caption">
                                        <div>Activos libres</div>
                                    </div>
                                </div>
                            </article>
                        </div><!--.col-->
                        <div class="col-sm-6">
                            <article class="statistic-box yellow">
                                <div>
                                    <div class="number" id="activos-en-mantenimiento">0</div>
                                    <div class="caption">
                                        <div>Activos en mantenimiento</div>
                                    </div>
                                </div>
                            </article>
                        </div><!--.col-->
                        <div class="col-sm-6">
                            <article class="statistic-box green">
                                <div>
                                    <div class="number" id="activos-en-centro">0</div>
                                    <div class="caption">
                                        <div>Activos en planta</div>
                                    </div>
                                </div>
                            </article>
                        </div><!--.col-->
                    </div><!--.row-->
                </div><!--.col-->

                <div class="row">
                    <div class="col-lg-6">
                        <section class="card">
                            <header class="card-header">
                                Activos por Estado
                            </header>
                            <div class="card-block">
                                <div id="pie-chart"></div>
                            </div>
                        </section>
                    </div>
                    <div class="col-lg-6">
                        <section class="card">
                            <header class="card-header">
                                Activos por Centro
                            </header>
                            <div class="card-block">
                                <div id="donut-chart"></div>
                            </div>
                        </section>
                    </div>
                </div><!--.page-content-->
            </div><!--.row-->

            <?php require_once("../js/js.php") ?>
            <script type="text/javascript" src="home.js"></script>

    </body>

    </html>
<?php
} else {
    header("Location:" . Conectar::ruta() . "index.php");
}
?>
