<?php
require_once("../../config/config.php");
require_once("../../config/conexion.php");

if (session_status() === PHP_SESSION_NONE) {
    session_start();
}

if (isset($_SESSION["Ccod_usu"])) {
?>

    <!DOCTYPE html>
    <html lang="es">

    <head>
        <meta charset="UTF-8">
        <meta name="viewport" content="width=device-width, initial-scale=1.0">
        <title>Repositorio de Imágenes</title>
        <?php require_once("../head/head.php") ?>

        <script type="text/javascript">
            var baseURL = "<?= $base_url; ?>";
        </script>
    </head>

    <body>
        <?php require_once("../header/header.php"); ?>
        <div class="page-content">
            <div class="container-fluid">
                <header class="box-typical-header box-typical-header-bordered">
                    <h2>Repositorio de imagenes</h2>
                    <h6>En esta ventana, podrás visualizar y registrar cada imagen asociada a un activo.</h6>
                    <p></p>
                    <ol class="breadcrumb breadcrumb-simple">
                        <li><a href="../home/home.php">Inicio</a></li>
                        <li class="active">Repositorio de imagenes</li>
                    </ol>
                </header>

                <div class="box-typical box-typical-padding">
                    <div class="box-typical-body">
                        <div class="tbl">
                            <div class="tbl-row">
                                <div class="tbl-cell">
                                    <div class="form-group">
                                        <label for="Ccod_serieID_filter">Seleccionar Activo</label>
                                        <select id="Ccod_serieID_filter" name="Ccod_serieID_filter" class="form-control select2"></select>
                                    </div>

                                    <div class="form-group">
                                        <label for="C_categ_filter">Seleccionar Categoría</label>
                                        <select id="C_categ_filter" name="C_categ_filter" class="form-control"></select>
                                    </div>

                                    <button type="button" class="btn btn-primary" data-toggle="modal" data-target="#modalmtnanexo">Registrar Nuevas Imágenes</button>

                                    <div class="gallery-grid">
                                        <!-- Imágenes cargadas dinámicamente -->
                                    </div><!--.gallery-grid-->
                                    <a href="../activo/index.php" class="btn btn-secondary">Regresar</a>
                                </div><!--.box-typical-body-->
                            </div>
                        </div><!--.container-fluid-->
                    </div>
                </div>
            </div>
        </div>

        <?php include("modalmtn.php"); ?>
        <?php require_once("../js/js.php") ?>
        <script src="mtnanexo.js"></script>
    </body>

    </html>

<?php
} else {
    header("Location:" . Conectar::ruta() . "index.php");
    exit();
}
?>