<?php
require_once("../../config/conexion.php");

// Asegúrate de que la sesión esté iniciada
if (session_status() === PHP_SESSION_NONE) {
    session_start();
}

// Verifica si el usuario ha iniciado sesión
if (isset($_SESSION["Ccod_usu"])) {
    $rol_id = $_SESSION["N_rolID"]; // Obtén el rol del usuario de la sesión
?>
    <!DOCTYPE html>
    <html lang="es">

    <head>
        <?php require_once("../head/head.php"); ?>
        <title>Gestor de Activos</title>
    </head>

    <body class="with-side-menu" data-rol="<?php echo htmlspecialchars($rol_id, ENT_QUOTES, 'UTF-8'); ?>"> <!-- Aquí pasamos el rol como atributo data -->

        <?php require_once("../header/header.php"); ?>

        <div class="mobile-menu-left-overlay"></div>
        <?php require_once("../nav/nav.php"); ?>

        <div class="page-content">
            <div class="container-fluid">
                <header class="section-header">
                    <div class="tbl">
                        <div class="tbl-row">
                            <div class="tbl-cell">
                                <h2>Ventana de activos</h2>
                                <h6> En esta ventana, podrás visualizar, registrar y editar la data de cada activo.</h6>
                                <p></p>
                                <ol class="breadcrumb breadcrumb-simple">
                                    <li><a href="../home/home.php">Inicio</a></li>
                                    <li class="active">Registro de Activos</li>
                                </ol>
                            </div>
                        </div>
                    </div>
                </header>
                <div class="box-typical box-typical-padding">
                    <table id="activo_tabla" class="display table table-bordered" cellspacing="0" width="100%">
                        <thead>
                            <tr>
                                <th class="d-none d-sm-table-cell" style="width: 5%;">Número de serie</th>
                                <th style="width: 10%;">Descripción actual</th>
                                <th class="text-center" style="width: 10%;">Material</th>
                                <th class="text-center" style="width: 10%;">Cliente (RUC)</th>
                                <th class="text-center" style="width: 10%;">Estado</th>
                                <th class="text-center" style="width: 10%;">Tipo de Activo</th>
                                <th class="text-center" style="width: 10%;">Centro</th>
                                <th class="text-center" style="width: 10%;">Zona</th>
                                <th class="text-center" style="width: 10%;">Último Retiro</th>
                                <th class="text-center" style="width: 10%;">Último Despacho</th>
                                <th class="text-center" style="width: 10%;">Último Mantenimiento</th>
                                <th class="text-center" style="width: 10%;">Última reparación</th>
                                <th class="text-center" style="width: 5%;">Antigüedad</th>
                                <th class="text-center" style="width: 5%;">visualizar</th>
                                <th class="text-center" style="width: 5%;">Editar</th>
                            </tr>
                        </thead>
                        <tbody>
                        </tbody>
                    </table>

                    <button id="btnnuevo" type="button" class="btn btn-rounded btn-inline btn-primary">Nuevo Activo</button>



                </div>
            </div><!--.container-fluid-->
        </div><!--.page-content-->

        <?php require_once("modalmtn.php"); ?>
        <?php require_once("../js/js.php"); ?>

        <script type="text/javascript" src="mtnactivo.js"></script>

    </body>

    </html>
<?php
} else {
    header("Location: " . Conectar::ruta() . "index.php");
    exit();
}
?>