<?php
class Ubicacion extends Conectar
{
    private $conectar;
    // Constructor que inicializa la conexión
    public function __construct()
    {
        $this->conectar = parent::conexion();
        parent::set_names();
    }
    // Método para insertar o actualizar una ubicación
    public function insert_ubicacion($Ccod_SerieID, $Ccod_centroID, $Ccod_zonaID, $Ccod_usu, $is_update = false)
    {
        // Manejar los valores nulos
        $Ccod_centroID = !empty($Ccod_centroID) ? $Ccod_centroID : NULL;
        $Ccod_zonaID = !empty($Ccod_zonaID) ? $Ccod_zonaID : NULL;

        if ($is_update) {
            // En una actualización, NO modificar Dfech_ubi
            $sql = "UPDATE ubicacion 
                    SET Ccod_centroID = ?, Ccod_zonaID = ?, Ccod_usu_mod = (SELECT Ccod_usuID FROM usuario WHERE Ccod_usu = ?), 
                    Dfech_usu_mod = NOW() 
                    WHERE Ccod_SerieID = ?
                    ORDER BY Ccod_ubiID DESC 
                    LIMIT 1";

            $stmt = $this->conectar->prepare($sql);
            $stmt->execute([$Ccod_centroID, $Ccod_zonaID, $Ccod_usu, $Ccod_SerieID]);
        } else {
            // En una creación, insertar Dfech_ubi
            $sql = "INSERT INTO ubicacion (Ccod_SerieID, Ccod_centroID, Ccod_zonaID, Ccod_usu_crea, Dfech_ubi)
                    VALUES (?, ?, ?, (SELECT Ccod_usuID FROM usuario WHERE Ccod_usu = ?), NOW())";

            $stmt = $this->conectar->prepare($sql);
            $stmt->execute([$Ccod_SerieID, $Ccod_centroID, $Ccod_zonaID, $Ccod_usu]);
        }

        return true;
    }


    // Método para obtener el historial de ubicaciones
    public function get_ubicaciones()
    {
        $sql = "SELECT u.Ccod_ubiID, a.Ccod_serie, u.Ccod_centroID, c.Sdesc_centro, u.Ccod_zonaID, z.Cdes_zona, u.Dfech_ubi, 
                u.Ccod_usu_crea, us.Nom_usu AS Nom_usu_crea, rol_c.Sdescrip AS Rol_crea,  
                u.Ccod_usu_mod, us_mod.Nom_usu AS Nom_usu_mod, rol_m.Sdescrip AS Rol_mod,  
                u.Dfech_usu_mod 
                FROM ubicacion u
                LEFT JOIN activo a ON u.Ccod_SerieID = a.Ccod_serieID
                LEFT JOIN centro c ON u.Ccod_centroID = c.Ccod_centroID
                LEFT JOIN zona z ON u.Ccod_zonaID = z.Ccod_zonaID
                LEFT JOIN usuario us ON u.Ccod_usu_crea = us.Ccod_usuID
                LEFT JOIN usuario us_mod ON u.Ccod_usu_mod = us_mod.Ccod_usuID
                LEFT JOIN rol rol_c ON us.N_rolID = rol_c.N_rolID
                LEFT JOIN rol rol_m ON us_mod.N_rolID = rol_m.N_rolID";

        $stmt = $this->conectar->prepare($sql);
        $stmt->execute();
        return $stmt->fetchAll(PDO::FETCH_ASSOC);
    }
}
