<?php
class Tipoactivo extends Conectar
{
    public function listar()
    {
        $conectar = parent::conexion();
        parent::set_names();
        $sql = "SELECT * FROM tipo_activo";
        $stmt = $conectar->prepare($sql);
        $stmt->execute();
        return $stmt->fetchAll(PDO::FETCH_ASSOC);
    }

    public function mostrar($Ccod_tipo_actID)
    {
        $conectar = parent::conexion();
        parent::set_names();
        $sql = "SELECT * FROM tipo_activo WHERE Ccod_tipo_actID = ?";
        $stmt = $conectar->prepare($sql);
        $stmt->bindValue(1, $Ccod_tipo_actID, PDO::PARAM_INT);
        $stmt->execute();
        return $stmt->fetch(PDO::FETCH_ASSOC);
    }

    public function insertar($Ccod_tipo_act, $Cdes_tipo_act, $Cruta_act)
    {
        $conectar = parent::conexion();
        parent::set_names();
        $sql = "INSERT INTO tipo_activo (Ccod_tipo_act, Cdes_tipo_act, Cruta_act) VALUES (?, ?, ?)";
        $stmt = $conectar->prepare($sql);
        $stmt->bindValue(1, $Ccod_tipo_act, PDO::PARAM_STR);
        $stmt->bindValue(2, $Cdes_tipo_act, PDO::PARAM_STR);
        $stmt->bindValue(3, $Cruta_act, PDO::PARAM_STR);
        $stmt->execute();
        return $stmt->rowCount();
    }

    public function editar($Ccod_tipo_actID, $Ccod_tipo_act, $Cdes_tipo_act, $Cruta_act)
    {
        $conectar = parent::conexion();
        parent::set_names();
        $sql = "UPDATE tipo_activo SET Ccod_tipo_act = ?, Cdes_tipo_act = ?, Cruta_act = ? WHERE Ccod_tipo_actID = ?";
        $stmt = $conectar->prepare($sql);
        $stmt->bindValue(1, $Ccod_tipo_act, PDO::PARAM_STR);
        $stmt->bindValue(2, $Cdes_tipo_act, PDO::PARAM_STR);
        $stmt->bindValue(3, $Cruta_act, PDO::PARAM_STR);
        $stmt->bindValue(4, $Ccod_tipo_actID, PDO::PARAM_INT);
        $stmt->execute();
        return $stmt->rowCount();
    }

    public function eliminar($Ccod_tipo_actID)
    {
        $conectar = parent::conexion();
        parent::set_names();
        $sql = "DELETE FROM tipo_activo WHERE Ccod_tipo_actID = ?";
        $stmt = $conectar->prepare($sql);
        $stmt->bindValue(1, $Ccod_tipo_actID, PDO::PARAM_INT);
        $stmt->execute();
        return $stmt->rowCount();
    }
}
