
<?php
// Nueva forma de estructura del codigo (prototipo xD)
class Activo extends Conectar
{
    private $conectar;

    public function __construct()
    {
        $this->conectar = parent::conexion();
        parent::set_names();
    }

    public function get_activos()
    {
        $sql = "SELECT a.Ccod_serieID, a.Ccod_serie, a.Cdesc_Seri, c.Ccod_clieID, c.RUC_clie, m.Ccod_matID, m.Cdescrip, e.Ccod_estID, e.Edescrip, 
                       z.Ccod_zonaID, z.Cdes_zona, ce.Ccod_centroID, ce.Sdesc_centro, ta.Ccod_tipo_actID, ta.Ccod_tipo_act,
                       a.Dult_ret, a.Dult_desp, a.Dult_mnt, a.Dult_rep, a.Stiem_ant 
                FROM activo a
                LEFT JOIN cliente c ON a.Ccod_clieID = c.Ccod_clieID 
                INNER JOIN material m ON a.Ccod_matID = m.Ccod_matID
                INNER JOIN estado e ON a.Ccod_estID = e.Ccod_estID
                LEFT JOIN zona z ON a.Ccod_zonaID = z.Ccod_zonaID
                LEFT JOIN centro ce ON a.Ccod_centroID = ce.Ccod_centroID
                INNER JOIN tipo_activo ta ON a.Ccod_tipo_act = ta.Ccod_tipo_actID";
        $stmt = $this->conectar->prepare($sql);
        $stmt->execute();
        return $stmt->fetchAll(PDO::FETCH_ASSOC);
    }


    public function get_activo_id($Ccod_serieID)
    {
        $sql = "SELECT * FROM activo WHERE Ccod_serieID = ?";
        $stmt = $this->conectar->prepare($sql);
        $stmt->execute([$Ccod_serieID]);
        return $stmt->fetch(PDO::FETCH_ASSOC);
    }

    public function verificar_duplicado($Ccod_serie, $Ccod_serieID = null)
    {
        $sql = "SELECT Ccod_serieID FROM activo WHERE Ccod_serie = ?";
        if ($Ccod_serieID) {
            // Evitar comparar con el mismo registro al editar
            $sql .= " AND Ccod_serieID != ?";
        }
        $stmt = $this->conectar->prepare($sql);
        if ($Ccod_serieID) {
            $stmt->execute([$Ccod_serie, $Ccod_serieID]);
        } else {
            $stmt->execute([$Ccod_serie]);
        }
        return $stmt->fetch() ? true : false; // Retorna true si hay un duplicado
    }



    public function get_activo_detalle($Ccod_serieID)
    {
        $sql = "SELECT a.Ccod_serie, a.Cdesc_Seri, 
                   IFNULL(c.RUC_clie, 'Cliente no asignado') AS RUC_clie, 
                   m.Cdescrip, e.Edescrip, 
                   IFNULL(ce.Sdesc_centro, 'En posesión del cliente') AS Sdesc_centro, 
                   IFNULL(z.Cdes_zona, 'En posesión del cliente') AS Cdes_zona, 
                   ta.Ccod_tipo_actID, ta.Ccod_tipo_act, ta.Cdes_tipo_act, ta.Cruta_act,
                   a.Dult_ret, a.Dult_desp, a.Dult_mnt, a.Dult_rep, a.Stiem_ant
            FROM activo a
            LEFT JOIN cliente c ON a.Ccod_clieID = c.Ccod_clieID
            INNER JOIN material m ON a.Ccod_matID = m.Ccod_matID
            INNER JOIN estado e ON a.Ccod_estID = e.Ccod_estID
            LEFT JOIN zona z ON a.Ccod_zonaID = z.Ccod_zonaID
            LEFT JOIN centro ce ON a.Ccod_centroID = ce.Ccod_centroID
            INNER JOIN tipo_activo ta ON a.Ccod_tipo_act = ta.Ccod_tipo_actID
            WHERE a.Ccod_serieID = ?";
        $stmt = $this->conectar->prepare($sql);
        $stmt->execute([$Ccod_serieID]);
        $result = $stmt->fetch(PDO::FETCH_ASSOC);

        if ($result) {
            // Limpia la ruta para que sea relativa al base_url
            $result['Cruta_act'] = str_replace('../', '', $result['Cruta_act']);
        }

        return $result;
    }


    public function insert_activo($Ccod_serie, $Cdesc_Seri, $Ccod_clieID, $Ccod_matID, $Ccod_estID, $Ccod_centroID, $Ccod_zonaID, $Ccod_tipo_actID, $Dult_ret, $Dult_desp, $Dult_mnt, $Dult_rep, $Stiem_ant)
    {
        $sql = "INSERT INTO activo (Ccod_serie, Cdesc_Seri, Ccod_clieID, Ccod_matID, Ccod_estID, Ccod_centroID, Ccod_zonaID, Ccod_tipo_act, Dult_ret, Dult_desp, Dult_mnt, Dult_rep, Stiem_ant) 
            VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
        $stmt = $this->conectar->prepare($sql);
        $stmt->execute([$Ccod_serie, $Cdesc_Seri, $Ccod_clieID, $Ccod_matID, $Ccod_estID, $Ccod_centroID ?: NULL, $Ccod_zonaID ?: NULL, $Ccod_tipo_actID, $Dult_ret, $Dult_desp, $Dult_mnt, $Dult_rep, $Stiem_ant]);
        $Ccod_serieID = $this->conectar->lastInsertId();

        // Insertar en el historial de ubicaciones
        $ubicacion = new Ubicacion();
        $ubicacion->insert_ubicacion($Ccod_serieID, $Ccod_centroID ?: NULL, $Ccod_zonaID ?: NULL, $_SESSION["Ccod_usu"]);

        return $Ccod_serieID;
    }
    public function update_activo($Ccod_serieID, $Ccod_serie, $Cdesc_Seri, $Ccod_clieID, $Ccod_matID, $Ccod_estID, $Ccod_centroID, $Ccod_zonaID, $Ccod_tipo_actID, $Dult_ret, $Dult_desp, $Dult_mnt, $Dult_rep, $Stiem_ant)
    {
        $sql = "UPDATE activo 
                SET Ccod_serie = ?, Cdesc_Seri = ?, Ccod_clieID = ?, Ccod_matID = ?, Ccod_estID = ?, Ccod_centroID = ?, Ccod_zonaID = ?, Ccod_tipo_act = ?, Dult_ret = ?, Dult_desp = ?, Dult_mnt = ?, Dult_rep = ?, Stiem_ant = ? 
                WHERE Ccod_serieID = ?";
        $stmt = $this->conectar->prepare($sql);
        $stmt->execute([$Ccod_serie, $Cdesc_Seri, $Ccod_clieID, $Ccod_matID, $Ccod_estID, $Ccod_centroID, $Ccod_zonaID, $Ccod_tipo_actID, $Dult_ret, $Dult_desp, $Dult_mnt, $Dult_rep, $Stiem_ant, $Ccod_serieID]);
        return true;
    }
    public function get_zonas_por_centro($Ccod_centroID)
    {
        $sql = "SELECT Ccod_zonaID, Cdes_zona FROM zona WHERE Ccod_centroID = ? AND Cactivo = 1";
        $stmt = $this->conectar->prepare($sql);
        $stmt->execute([$Ccod_centroID]);
        return $stmt->fetchAll(PDO::FETCH_ASSOC);
    }

    // Métodos para obtener datos relacionados
    public function get_estado()
    {
        $sql = "SELECT * FROM estado WHERE Est_esta = 1";
        $stmt = $this->conectar->prepare($sql);
        $stmt->execute();
        return $stmt->fetchAll(PDO::FETCH_ASSOC);
    }

    public function get_cliente_est()
    {
        $sql = "SELECT * FROM cliente WHERE Est_clie = 1";
        $stmt = $this->conectar->prepare($sql);
        $stmt->execute();
        return $stmt->fetchAll(PDO::FETCH_ASSOC);
    }

    public function get_material_est()
    {
        $sql = "SELECT * FROM material WHERE Cest_mat = 1";
        $stmt = $this->conectar->prepare($sql);
        $stmt->execute();
        return $stmt->fetchAll(PDO::FETCH_ASSOC);
    }

    public function get_zona_est()
    {
        $sql = "SELECT * FROM zona WHERE Cactivo = 1";
        $stmt = $this->conectar->prepare($sql);
        $stmt->execute();
        return $stmt->fetchAll(PDO::FETCH_ASSOC);
    }

    public function get_centro_est()
    {
        $sql = "SELECT * FROM centro";
        $stmt = $this->conectar->prepare($sql);
        $stmt->execute();
        return $stmt->fetchAll(PDO::FETCH_ASSOC);
    }

    public function get_tipo_activo()
    {
        $sql = "SELECT * FROM tipo_activo";
        $stmt = $this->conectar->prepare($sql);
        $stmt->execute();
        return $stmt->fetchAll(PDO::FETCH_ASSOC);
    }
    public function get_anexos_por_categoria($Ccod_serieID, $categoria)
    {
        $sql = "SELECT * FROM anexo_archivos WHERE Ccod_serieID = ? AND C_categ = ?";
        $stmt = $this->conectar->prepare($sql);
        $stmt->execute([$Ccod_serieID, $categoria]);
        return $stmt->fetchAll(PDO::FETCH_ASSOC);
    }
}
