<?php
require_once("config/conexion.php");

if (session_status() === PHP_SESSION_NONE) {
    session_start();
}

// Redirige al usuario a la página principal si ya está autenticado
if (isset($_SESSION['Ccod_usu'])) {
    header("Location: vistas/activo/index.php");
    exit();
}

$error = ""; // Inicializa la variable de error

if (isset($_SESSION['login_error'])) {
    $error = $_SESSION['login_error'];
    unset($_SESSION['login_error']); // Limpiar el mensaje de error después de mostrarlo
}

if ($_SERVER["REQUEST_METHOD"] == "POST") {
    if (!empty($_POST['Ccod_usu']) && !empty($_POST['Pass_usu'])) {
        require_once("modelos/Usuario.php");
        $usuario = new Usuario();

        // Sanitiza las entradas del usuario
        $username = htmlspecialchars(trim($_POST['Ccod_usu']), ENT_QUOTES, 'UTF-8');
        $password = htmlspecialchars(trim($_POST['Pass_usu']), ENT_QUOTES, 'UTF-8');

        // Intenta iniciar sesión
        if ($usuario->login($username, $password)) {
            // Redirige al usuario a la página principal si el login es exitoso
            header("Location: vistas/home.php");
            exit();
        } else {
            $error = "Nombre de usuario o contraseña incorrectos. Por favor, inténtalo de nuevo.";
        }
    } else {
        $error = "Por favor, complete todos los campos para iniciar sesión.";
    }
}
?>

<!DOCTYPE html>
<html lang="es">

<head>
    <meta charset="UTF-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>QR modular</title>
    <link rel="stylesheet" href="https://fonts.googleapis.com/css2?family=Material+Symbols+Outlined:opsz,wght,FILL,GRAD@48,600,0,0" />
    <link rel="stylesheet" href="publico/css/login.css" />
    <style>
        .link-plain {
            text-decoration: none;
            color: inherit;
        }
    </style>
</head>

<body>
    <div class="login">
        <div class="avatar-container">
            <div class="avatar">
                <img src="publico/img/logoPrecor.jpg" alt="Logo" />
            </div>
        </div>
        <h2>Acceso</a></h2>
        <h3>Bienvenido al sistema QRmodular</h3>

        <?php if (!empty($error)): ?>
            <div class="error-message">
                <p><?php echo $error; ?></p>
            </div>
        <?php endif; ?>

        <form class="login-form" action="" method="post" id="login_form">
            <div class="textbox">
                <input type="text" id="Ccod_usu" name="Ccod_usu" placeholder="Nombre de usuario" value="<?php echo isset($_POST['Ccod_usu']) ? htmlspecialchars($_POST['Ccod_usu'], ENT_QUOTES) : ''; ?>" />
                <span class="material-symbols-outlined"> account_circle </span>
            </div>
            <div class="textbox">
                <input type="password" id="Pass_usu" name="Pass_usu" placeholder="Contraseña" />
                <span class="material-symbols-outlined"> lock </span>
            </div>
            <input type="hidden" name="enviar" class="form-control" value="si">
            <button type="submit">LOGIN</button>
        </form>
    </div>
</body>

</html>
