<?php
require_once("../../config/config.php");
require_once("../../config/conexion.php");
// Asegúrate de que la sesión esté iniciada
if (session_status() === PHP_SESSION_NONE) {
    session_start();
}

// Verifica si el usuario ha iniciado sesión
if (isset($_SESSION["Ccod_usu"])) {
?>

<!DOCTYPE html>
<html>
<?php require_once("../head/head.php") ?>
<title>Historial de Ubicaciones</title>

</head>

<body class="with-side-menu">

    <?php require_once("../header/header.php") ?>

    <div class="mobile-menu-left-overlay"></div>
    <?php require_once("../nav/nav.php") ?>

    <div class="page-content">
        <div class="container-fluid">
            <header class="section-header">
                <div class="tbl">
                    <div class="tbl-row">
                        <div class="tbl-cell">
                            <h3>Historial de Ubicaciones</h3>
                            <h6>En esta ventana, podrás visualizar registros y ubicaciones de un activo.</h6>
                            <p></p>
                            <ol class="breadcrumb breadcrumb-simple">
                                <li><a href="../home/home.php">Inicio</a></li>
                                <li class="active">Historial de Ubicaciones</li>
                            </ol>
                        </div>
                    </div>
                </div>
            </header>
            <div class="box-typical box-typical-padding">
                <table id="historial_tabla" class="display table table-bordered" cellspacing="0" width="100%">
                    <thead>
                        <tr>
                        <th class="d-none d-sm-table-cell" style="width: 5%;">Número de serie</th>
                        <th class="d-none d-sm-table-cell" style="width: 5%;">Centro</th>
                        <th class="d-none d-sm-table-cell" style="width: 5%;">Zona</th>
                        <th class="d-none d-sm-table-cell" style="width: 5%;">Fecha de Ubicación</th>
                        <th class="d-none d-sm-table-cell" style="width: 5%;">Usuario Creador</th>
                        <th class="d-none d-sm-table-cell" style="width: 5%;">Rol</th>
                        <th class="d-none d-sm-table-cell" style="width: 5%;">Usuario Modificador</th>
                        <th class="d-none d-sm-table-cell" style="width: 5%;">Rol</th>
                        <th class="d-none d-sm-table-cell" style="width: 5%;">Fecha de Modificación</th>
                        </tr>
                    </thead>
                    <tbody>
                    </tbody>
                </table>
            </div>
        </div>
    </div>

    <?php require_once("../js/js.php") ?>
    <script type="text/javascript" src="mtnubicacion.js"></script>

</body>

</html>

<?php
} else {
    header("Location:" . Conectar::ruta() . "index.php");
}
?>

