<?php
require_once("../../config/conexion.php");
// Asegúrate de que la sesión esté iniciada
if (session_status() === PHP_SESSION_NONE) {
    session_start();
}

// Verifica si el usuario ha iniciado sesión
if (isset($_SESSION["Ccod_usu"])) {
?>

<!DOCTYPE html>
<html>
<?php require_once("../head/head.php") ?>
<title>Gestor de Roles</title>

</head>

<body class="with-side-menu">

    <?php require_once("../header/header.php") ?>

    <div class="mobile-menu-left-overlay"></div>
    <?php require_once("../nav/nav.php") ?>

    <div class="page-content">
        <div class="container-fluid">
            <header class="section-header">
                <div class="tbl">
                    <div class="tbl-row">
                        <div class="tbl-cell">
                            <h3>Registro de Roles</h3>
                            <h6>En esta ventana, podrás visualizar, registrar y editar los roles asignados a un usuario.</h6>
                            <p></p>
                            <ol class="breadcrumb breadcrumb-simple">
                                <li><a href="../home/home.php">Inicio</a></li>
                                <li class="active">Registro de Roles</li>
                            </ol>
                        </div>
                    </div>
                </div>
            </header>
            <div class="box-typical box-typical-padding">
                <table id="rol_tabla" class="table table-bordered table-striped table-vcenter js-dataTable-full">
                    <thead>
                        <tr>
                        <th class="d-none d-sm-table-cell" style="width: 2%;">ID</th>
                            <th class="d-none d-sm-table-cell" style="width: 10%;">Rol</th>
                            <th class="d-none d-sm-table-cell" style="width: 5%;">Estado</th>
                            <th class="text-center" style="width: 5%;"></th>
                        </tr>
                    </thead>
                    <tbody></tbody>
                </table>
                <button type="button" class="btn btn-outline-success" id="btnnuevo">
                    <i class="fa fa-plus"></i> Nuevo
                </button>
            </div>
        </div>
    </div>

    <?php require_once("modalmtn.php") ?>
    <?php require_once("../js/js.php") ?>
    <script type="text/javascript" src="mtnrol.js"></script>

</body>

</html>
<?php
} else {
    header("Location:../../index.php");
}
?>
