$(document).ready(function() {
    var tabla;

    function init() {
        listar();
        cargar_tablas();
        cargar_roles();

        $("#btnnuevo").on("click", function() {
            mostrar_formulario(true);
        });

        $("#formulario").on("submit", function(e) {
            guardaryeditar(e);
        });

        $("#Ctab_per").on("change", function() {
            cargar_atributos($(this).val());
        });
    }

    function limpiar() {
        $("#Npermi_ID").val("");
        $("#Ctab_per").val("");
        $("#Catrib_per").html(""); // Vaciar el combo de atributos
        $("#Ctipo_per").val("");
        $("#N_rolID").val("");
    }

    function mostrar_formulario(flag) {
        limpiar();
        if (flag) {
            $("#modalmtn").modal("show");
        } else {
            $("#modalmtn").modal("hide");
        }
    }

    function listar() {
        tabla = $('#permiso_tabla').DataTable({
            "aProcessing": true,
            "aServerSide": true,
            dom: 'Bfrtip',
            buttons: ['copyHtml5', 'excelHtml5', 'csvHtml5'],
            "ajax": {
                url: '../../controladores/permiso.php?op=listar',
                type: "get",
                dataType: "json",
                error: function(e) {
                    console.log(e.responseText);
                }
            },
            "bDestroy": true,
            "iDisplayLength": 10,
            "order": [[0, "asc"]],
            "language": {
                "sProcessing": "Procesando...",
                "sLengthMenu": "Mostrar _MENU_ registros",
                "sZeroRecords": "No se encontraron resultados",
                "sEmptyTable": "Ningún dato disponible en esta tabla",
                "sInfo": "Mostrando registros del _START_ al _END_ de un total de _TOTAL_ registros",
                "sInfoEmpty": "Mostrando registros del 0 al 0 de un total de 0 registros",
                "sInfoFiltered": "(filtrado de un total de _MAX_ registros)",
                "sSearch": "Buscar:",
                "oPaginate": {
                    "sFirst": "Primero",
                    "sLast": "Último",
                    "sNext": "Siguiente",
                    "sPrevious": "Anterior"
                }
            }
        });
    }

    function guardaryeditar(e) {
        e.preventDefault(); // Evita el comportamiento por defecto del submit
        var formData = new FormData($("#formulario")[0]);

        $.ajax({
            url: "../../controladores/permiso.php?op=guardaryeditar",
            type: "POST",
            data: formData,
            contentType: false,
            processData: false,
            success: function(datos) {
                swal({
                    title: "Sistema Modular QR",
                    text: "Completado.",
                    type: "success",
                    confirmButtonClass: "btn-success",
                });
                mostrar_formulario(false);
                tabla.ajax.reload();
            }
        });
    }

    function mostrar(Npermi_ID) {
        $.post("../../controladores/permiso.php?op=mostrar", { Npermi_ID: Npermi_ID }, function(data, status) {
            data = JSON.parse(data);
            mostrar_formulario(true);
            $("#Npermi_ID").val(data.Npermi_ID);
            $("#Ctab_per").val(data.Ctab_per);
            cargar_atributos(data.Ctab_per, data.Catrib_per);
            $("#Ctipo_per").val(data.Ctipo_per);
            $("#N_rolID").val(data.N_rolID);
        });
    }

    function cargar_atributos(tabla, atributoSeleccionado = '') {
        $.post("../../controladores/permiso.php?op=obtener_atributos", { tabla: tabla }, function(data) {
            $("#Catrib_per").html(data);
            if (atributoSeleccionado) {
                $("#Catrib_per").val(atributoSeleccionado);
            }
        });
    }

    function cargar_tablas() {
        $.post("../../controladores/permiso.php?op=obtener_tablas", function(data) {
            $("#Ctab_per").html(data);
        });
    }

    function cargar_roles() {
        $.post("../../controladores/permiso.php?op=obtener_roles", function(data) {
            $("#N_rolID").html(data);
        });
    }

    function eliminar(Npermi_ID) {
        swal({
            title: "¿Está seguro?",
            text: "¡El registro no podrá ser recuperado!",
            type: "warning",
            showCancelButton: true,
            confirmButtonClass: "btn-danger",
            confirmButtonText: "Sí, eliminar",
            closeOnConfirm: false
        },
        function() {
            $.post("../../controladores/permiso.php?op=eliminar", { Npermi_ID: Npermi_ID }, function(e) {
                swal({
                    title: "Sistema Modular QR",
                    text: "Registro eliminado.",
                    type: "success",
                    confirmButtonClass: "btn-success",
                });
                tabla.ajax.reload();
            });
        });
    }

    window.mostrar = mostrar;
    window.eliminar = eliminar;

    init();
});
