$(document).ready(function () {
  function actualizarDatos() {
    // Actualizar Total de Activos
    $.ajax({
      url: "../../controladores/graficos.php?op=total_activos",
      method: "GET",
      dataType: "json",
      success: function (response) {
        $("#total-activos").text(response.total);
      },
      error: function (xhr, status, error) {
        console.error(
          "Error al obtener el total de activos:",
          xhr.responseText
        );
      },
    });

    // Actualizar Activos sin Cliente
    $.ajax({
      url: "../../controladores/graficos.php?op=activos_sin_cliente",
      method: "GET",
      dataType: "json",
      success: function (response) {
        $("#activos-sin-cliente").text(response.total);
      },
      error: function (xhr, status, error) {
        console.error(
          "Error al obtener activos sin cliente:",
          xhr.responseText
        );
      },
    });

    // Actualizar Activos en Mantenimiento
    $.ajax({
      url: "../../controladores/graficos.php?op=activos_en_mantenimiento",
      method: "GET",
      dataType: "json",
      success: function (response) {
        $("#activos-en-mantenimiento").text(response.total);
      },
      error: function (xhr, status, error) {
        console.error(
          "Error al obtener activos en mantenimiento:",
          xhr.responseText
        );
      },
    });

    // Actualizar Activos en Centro
    $.ajax({
      url: "../../controladores/graficos.php?op=activos_en_centro",
      method: "GET",
      dataType: "json",
      success: function (response) {
        $("#activos-en-centro").text(response.total);
      },
      error: function (xhr, status, error) {
        console.error("Error al obtener activos en centro:", xhr.responseText);
      },
    });

    // Actualizar Gráfico de Activos por Estado
    $.ajax({
      url: "../../controladores/graficos.php?op=activos_por_estado",
      method: "GET",
      dataType: "json",
      success: function (response) {
        var data = response.map(function (item) {
          return [item.Edescrip, item.total];
        });
        c3.generate({
          bindto: "#pie-chart",
          data: {
            columns: data,
            type: "pie",
          },
        });
      },
      error: function (xhr, status, error) {
        console.error("Error al obtener activos por estado:", xhr.responseText);
      },
    });

    $.ajax({
      url: "../../controladores/graficos.php?op=activos_por_centro",
      method: "GET",
      dataType: "json",
      success: function (response) {
        // Mapea los datos para C3.js
        var data = response.map(function (item) {
          return [item.Sdesc_centro, item.total]; // Formato esperado por C3.js
        });

        // Genera el gráfico de pastel (donut) con C3.js
        c3.generate({
          bindto: "#donut-chart", // ID del contenedor donde se renderiza el gráfico
          data: {
            columns: data, // Los datos mapeados
            type: "donut", // Tipo de gráfico: donut
          },
          donut: {
            title: "Activos por Centro", // Título del gráfico
          },
          tooltip: {
            format: {
              value: function (value, ratio, id) {
                // Formato del valor mostrado en el tooltip
                return value;
              },
            },
          },
        });
      },
      error: function (xhr, status, error) {
        console.error("Error al obtener activos por centro:", xhr.responseText);
      },
    });
  }

  // Actualizar los datos cada 4 segundos
  actualizarDatos();
  setInterval(actualizarDatos, 4000); // 4000 ms = 4 segundos
});
