var tabla;

function init() {
  $("#estado_form").on("submit", function (e) {
    guardaryeditar(e);
  });
}

$(document).ready(function () {
  tabla = $("#estado_tabla")
    .dataTable({
      aProcessing: true, //Activamos el procesamiento del datatables
      aServerSide: true, //Paginación y filtrado realizados por el servidor
      dom: "Bfrtip", //Definimos los elementos del control de tabla
      buttons: ["copyHtml5", "excelHtml5", "csvHtml5", "pdf"],
      ajax: {
        url: "../../controladores/estado.php?op=listar",
        type: "get",
        dataType: "json",
        error: function (e) {
          console.log(e.responseText);
        },
      },
      bDestroy: true,
      responsive: true,
      bInfo: true,
      iDisplayLength: 10,
      order: [[0, "asc"]],
      language: {
        sProcessing: "Procesando...",
        sLengthMenu: "Mostrar _MENU_ registros",
        sZeroRecords: "No se encontraron resultados",
        sEmptyTable: "Ningún dato disponible en esta tabla",
        sInfo:
          "Mostrando registros del _START_ al _END_ de un total de _TOTAL_ registros",
        sInfoEmpty: "Mostrando registros del 0 al 0 de un total de 0 registros",
        sInfoFiltered: "(filtrado de un total de _MAX_ registros)",
        sInfoPostFix: "",
        sSearch: "Buscar:",
        sUrl: "",
        sInfoThousands: ",",
        sLoadingRecords: "Cargando...",
        oPaginate: {
          sFirst: "Primero",
          sLast: "Último",
          sNext: "Siguiente",
          sPrevious: "Anterior",
        },
        oAria: {
          sSortAscending:
            ": Activar para ordenar la columna de manera ascendente",
          sSortDescending:
            ": Activar para ordenar la columna de manera descendente",
        },
      },
    })
    .DataTable();
});

function guardaryeditar(e) {
  e.preventDefault();
  var formData = new FormData($("#estado_form")[0]);
  $.ajax({
    url: "../../controladores/estado.php?op=guardaryeditar",
    type: "POST",
    data: formData,
    contentType: false,
    processData: false,
    success: function (datos) {
      $("#estado_form")[0].reset();
      $("#modalmtn").modal("hide");
      tabla.ajax.reload(function () {
        swal({
          title: "Sistema Modular QR",
          text: "Completado.",
          type: "success",
          confirmButtonClass: "btn-success",
        });
      });
    },
    error: function (xhr, ajaxOptions, thrownError) {
      console.log(xhr.responseText);
    },
  });
}

function editar(Ccod_estID) {
  $.post(
    "../../controladores/estado.php?op=mostrar",
    { Ccod_estID: Ccod_estID },
    function (data) {
      data = JSON.parse(data);
      $("#Ccod_estID").val(data.Ccod_estID);
      $("#Ccod_est").val(data.Ccod_est);
      $("#Edescrip").val(data.Edescrip);
      $("#Est_esta").val(data.Est_esta);
    }
  );
  $("#mdltitulo").html("Editar Estado");
  $("#modalmtn").modal("show");
}

$(document).on("click", "#btnnuevo", function () {
  $("#mdltitulo").html("Nuevo Estado");
  $("#modalmtn").modal("show");
  $("#estado_form")[0].reset();
  $("#Ccod_estID").val(""); // Asegurarse de que el campo oculto esté vacío para la creación
});

init();
