var tabla;

function init() {
  $("#cliente_form").on("submit", function (e) {
    guardaryeditar(e);
  });
}

$(document).ready(function () {
  tabla = $("#cliente_tabla")
    .dataTable({
      aProcessing: true,
      aServerSide: true,
      dom: "Bfrtip",
      buttons: ["copyHtml5", "excelHtml5", "csvHtml5"],
      ajax: {
        url: "../../controladores/cliente.php?op=listar",
        type: "get",
        dataType: "json",
        error: function (e) {
          console.log(e.responseText);
        },
      },
      bDestroy: true,
      responsive: true,
      bInfo: true,
      iDisplayLength: 10,
      order: [[0, "asc"]],
      language: {
        sProcessing: "Procesando...",
        sLengthMenu: "Mostrar _MENU_ registros",
        sZeroRecords: "No se encontraron resultados",
        sEmptyTable: "Ningún dato disponible en esta tabla",
        sInfo:
          "Mostrando registros del _START_ al _END_ de un total de _TOTAL_ registros",
        sInfoEmpty: "Mostrando registros del 0 al 0 de un total de 0 registros",
        sInfoFiltered: "(filtrado de un total de _MAX_ registros)",
        sInfoPostFix: "",
        sSearch: "Buscar:",
        sUrl: "",
        sInfoThousands: ",",
        sLoadingRecords: "Cargando...",
        oPaginate: {
          sFirst: "Primero",
          sLast: "Último",
          sNext: "Siguiente",
          sPrevious: "Anterior",
        },
        oAria: {
          sSortAscending:
            ": Activar para ordenar la columna de manera ascendente",
          sSortDescending:
            ": Activar para ordenar la columna de manera descendente",
        },
      },
    })
    .DataTable();
});

function guardaryeditar(e) {
  e.preventDefault();
  var formData = new FormData($("#cliente_form")[0]);
  $.ajax({
    url: "../../controladores/cliente.php?op=guardaryeditar",
    type: "POST",
    data: formData,
    contentType: false,
    processData: false,
    success: function (datos) {
      $("#cliente_form")[0].reset();
      $("#modalmtncliente").modal("hide");
      tabla.ajax.reload(function () {
        swal({
          title: "Sistema Modular QR",
          text: "Completado.",
          type: "success",
          confirmButtonClass: "btn-success",
        });
      });
    },
    error: function (xhr, ajaxOptions, thrownError) {
      console.log(xhr.responseText);
    },
  });
}

function editar(Ccod_clieID) {
  $.post(
    "../../controladores/cliente.php?op=mostrar",
    { Ccod_clieID: Ccod_clieID },
    function (data) {
      data = JSON.parse(data);
      $("#Ccod_clieID").val(data.Ccod_clieID);
      $("#Ccod_clie").val(data.Ccod_clie);
      $("#Nom_clie").val(data.Nom_clie);
      $("#Emp_clie").val(data.Emp_clie);
      $("#RUC_clie").val(data.RUC_clie);
      $("#Est_clie").val(data.Est_clie);
    }
  );
  $("#mdltitulo").html("Editar Cliente");
  $("#modalmtncliente").modal("show");
}

$(document).on("click", "#btnnuevo", function () {
  $("#mdltitulo").html("Nuevo Cliente");
  $("#modalmtncliente").modal("show");
  $("#cliente_form")[0].reset();
  $("#Ccod_clieID").val("");
});

init();
