$(document).ready(function () {
  // Cargar activos y categorías en los combos
  cargarActivos("#Ccod_serieID_filter");
  cargarActivos("#Ccod_serieID_modal");
  cargarCategorias();

  // Inicializar Select2 después de cargar los activos
  $("#Ccod_serieID_filter").select2({
    placeholder: "Buscar un activo",
    allowClear: true,
  });

  $("#Ccod_serieID_modal").select2({
    placeholder: "Buscar un activo",
    allowClear: true,
  });

  // Evento para llenar el campo de nombre del archivo y permitir su edición
  $("#file").on("change", function () {
    var fileName = $(this).val().split("\\").pop();
    $("#Cnomb_arch").val(fileName);
  });

  // Evento al hacer clic en el botón de guardar
  $("#btnGuardar").on("click", function () {
    guardarAnexos();
  });

  // Cargar galería al cambiar los combos de categoría o activo
  $("#C_categ_filter, #Ccod_serieID_filter").on("change", function () {
    cargarGaleria($("#C_categ_filter").val(), $("#Ccod_serieID_filter").val());
  });

  // Inicializa la galería vacía al cargar la página
  cargarGaleria($("#C_categ_filter").val(), $("#Ccod_serieID_filter").val());

  // Evento para abrir el modal de nuevo registro y reiniciar combos
  $("#btnnuevo").on("click", function () {
    resetearCombos();
    $("#modalmtnanexo").modal("show");
  });

  // Reestablecer combos al cerrar el modal para mantener los placeholders
  $("#modalmtnanexo").on("hidden.bs.modal", function () {
    resetearCombos();
  });
});

function cargarActivos(selector) {
  $.post("../../controladores/anexo.php?op=listar_activos", function (data) {
    var activos = JSON.parse(data);
    $(selector).empty(); // Limpiar antes de agregar nuevas opciones

    // Agregar opción por defecto
    $(selector).append(new Option("Buscar un activo", ""));

    $.each(activos, function (index, activo) {
      $(selector).append(
        new Option(
          activo.Ccod_serie + " - " + activo.Cdesc_Seri,
          activo.Ccod_serieID
        )
      );
    });

    // Re-inicializar Select2 después de cargar los datos
    $(selector)
      .select2({
        placeholder: "Buscar un activo",
        allowClear: true,
      })
      .val("")
      .trigger("change"); // Asegurar que se muestre el placeholder
  });
}

function cargarCategorias() {
  $.post("../../controladores/anexo.php?op=listar_categorias", function (data) {
    var categorias = JSON.parse(data);
    $("#C_categ, #C_categ_filter").empty(); // Limpiar ambos selects antes de agregar opciones

    // Agregar opción por defecto
    $("#C_categ, #C_categ_filter").append(
      new Option("Seleccione una categoría", "")
    );

    $.each(categorias, function (index, categoria) {
      $("#C_categ").append(new Option(categoria, categoria));
      $("#C_categ_filter").append(new Option(categoria, categoria));
    });

    // Inicializar Select2 para las categorías
    $("#C_categ_filter")
      .select2({
        placeholder: "Seleccione una categoría",
        allowClear: true,
      })
      .val("")
      .trigger("change"); // Asegurar que se muestre el placeholder
  });
}

// Función para manejar la descarga de archivos
$(document).on("click", ".btn-download", function () {
  var id = $(this).data("id");
  window.location.href = "../../controladores/anexo.php?op=descargar&id=" + id;
});

function guardarAnexos() {
  var formData = new FormData($("#anexo_form")[0]);

  // Mostrar SweetAlert de carga
  swal({
    title: "Cargando...",
    text: "Subiendo archivo, por favor espera.",
    icon: "info",
    buttons: false,
    closeOnClickOutside: false,
    closeOnEsc: false,
  });

  $.ajax({
    url: "../../controladores/anexo.php?op=insertar",
    type: "POST",
    data: formData,
    contentType: false,
    processData: false,
    success: function (response) {
      var result = JSON.parse(response);
      // Cerrar el SweetAlert de carga
      swal.close();

      if (result.status === "success") {
        swal("Completado", "Archivo guardado correctamente.", "success");
        $("#anexo_form")[0].reset();
        $("#modalmtnanexo").modal("hide");
        cargarGaleria(
          $("#C_categ_filter").val(),
          $("#Ccod_serieID_filter").val()
        ); // Recargar la galería después de guardar
      } else {
        swal(
          "Error",
          result.message || "Error al guardar el archivo.",
          "error"
        );
      }
    },
    error: function () {
      // Cerrar el SweetAlert de carga en caso de error
      swal.close();
      swal("Error", "Error en la petición.", "error");
    },
  });
}

// Función para manejar la eliminación de archivos con SweetAlert de confirmación
$(document).on("click", ".btn-delete", function () {
  var id = $(this).data("id");

  // Mostrar SweetAlert de confirmación antes de eliminar
  swal(
    {
      title: "¿Estás seguro?",
      text: "¡No podrás revertir esto!",
      type: "warning",
      showCancelButton: true,
      confirmButtonClass: "btn-danger",
      confirmButtonText: "Sí, eliminar",
      cancelButtonText: "No, cancelar",
      closeOnConfirm: false,
      closeOnCancel: false,
    },
    function (isConfirm) {
      if (isConfirm) {
        // Realizar la petición AJAX para eliminar el archivo
        $.ajax({
          url: "../../controladores/anexo.php?op=eliminar",
          type: "POST",
          data: { id: id },
          success: function (response) {
            var result = JSON.parse(response);
            if (result.status === "success") {
              swal({
                title: "Eliminado",
                text: "El archivo ha sido eliminado con éxito.",
                type: "success",
                confirmButtonClass: "btn-success",
              });
              cargarGaleria(
                $("#C_categ_filter").val(),
                $("#Ccod_serieID_filter").val()
              ); // Recargar galería
            } else {
              swal({
                title: "Error",
                text: result.message || "No se pudo eliminar el archivo.",
                type: "error",
                confirmButtonClass: "btn-danger",
              });
            }
          },
          error: function () {
            swal({
              title: "Error",
              text: "Hubo un problema al eliminar el archivo.",
              type: "error",
              confirmButtonClass: "btn-danger",
            });
          },
        });
      } else {
        swal({
          title: "Cancelado",
          text: "El archivo no fue eliminado.",
          type: "error",
          confirmButtonClass: "btn-danger",
        });
      }
    }
  );
});

// Cargar la galería (debe estar en otra parte del código)
function cargarGaleria(categoria, activo) {
  if (categoria && activo) {
    // Verificar que ambos no sean nulos
    $.get(
      "../../controladores/anexo.php?op=listar_anexos&C_categ=" +
        categoria +
        "&Ccod_serieID=" +
        activo,
      function (data) {
        var anexos = JSON.parse(data);
        var gallery = $(".gallery-grid").empty();
        $.each(anexos, function (index, anexo) {
          var rutaImagen = baseURL + anexo.Cruta_hist.replace("../", "");

          gallery.append(
            `<div class="gallery-col">
              <article class="gallery-item">
                <img class="gallery-picture" src="${rutaImagen}" alt="${
              anexo.Cnomb_arch
            }" height="158">
                <div class="gallery-hover-layout">
                  <div class="gallery-hover-layout-in">
                    <p class="gallery-item-title">${anexo.Cnomb_arch}</p>
                    <p class="gallery-item-subtitle">Creado por ${
                      anexo.Ccod_usu
                    }</p>
                    <div class="btn-group">
                      <button type="button" class="btn btn-download" data-id="${
                        anexo.Historial_ID
                      }">
                        <i class="font-icon font-icon-cloud"></i>
                      </button>
                      <button type="button" class="btn btn-delete" data-id="${
                        anexo.Historial_ID
                      }">
                        <i class="font-icon font-icon-trash"></i>
                      </button>
                    </div>
                    <p>${new Date(anexo.Dfech_crea).toLocaleDateString()}</p>
                  </div>
                </div>
              </article>
            </div><!--.gallery-col-->`
          );
        });
      }
    );
  } else {
    $(".gallery-grid").empty(); // Limpiar la galería si no se selecciona una categoría válida
  }
}

// Función para resetear los combos y el formulario
function resetearCombos() {
  $("#anexo_form")[0].reset(); // Reinicia los campos del formulario
  $("#Ccod_serieID_modal").val("").trigger("change"); // Reinicia el combo de activos
  $("#C_categ").val("").trigger("change"); // Reinicia el combo de categoría
}
