<?php
require_once("../../config/conexion.php");
require_once("../../modelos/ActivoCliente.php");
require_once("../../config/config.php");

function xorEncryptDecrypt($key, $data)
{
    $decodedData = base64_decode($data);
    $decrypted = '';
    for ($i = 0; $i < strlen($decodedData); $i++) {
        $decrypted .= chr(ord($decodedData[$i]) ^ ord($key[$i % strlen($key)]));
    }
    return $decrypted;
}

$key = '@457657#$878QQQ@';
if (isset($_GET["id"])) {
    $Ccod_serieID = xorEncryptDecrypt($key, $_GET["id"]);
    $activoCliente = new ActivoCliente();
    $datos = $activoCliente->get_activo_detalle($Ccod_serieID);

    if (is_array($datos) && count($datos) > 0) {
        $activo_data = $datos;
    } else {
        header("Location: index.php");
        exit();
    }
} else {
    header("Location: index.php");
    exit();
}
?>

<!DOCTYPE html>
<html lang="es">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Detalle del Activo</title>
    <?php require_once("../head/head.php"); ?>
    <script>
        var base_url = "<?php echo $base_url; ?>";
        var activoID = "<?= $Ccod_serieID ?>"; // Usar el ID desencriptado
    </script>
</head>

<body>
    <div class="page-content">
        <div class="container-fluid">
            <section class="box-typical box-typical-padding">
                <header class="box-typical-header">
                    <h3>Detalle del Activo</h3>
                </header>
                <div class="box-typical-body">
                    <div class="form-group">
                        <label>Código:</label>
                        <p><?= $activo_data["Ccod_serie"] ?></p>
                    </div>
                    <div class="form-group">
                        <label>Descripción:</label>
                        <p><?= $activo_data["Cdesc_Seri"] ?></p>
                    </div>
                    <div class="form-group">
                        <label>Especificaciones Técnicas:</label>
                        <div class="proj-page-attach">
                            <i class="font-icon font-icon-pdf"></i>
                            <p class="name"><?= basename($activo_data["Cruta_act"]) ?></p>
                            <p>
                                <a href="../../<?= $activo_data["Cruta_act"] ?>" target="_blank">Ver</a>
                                <a href="../../<?= $activo_data["Cruta_act"] ?>" download>Descargar</a>
                            </p>
                        </div>
                    </div>
                    <div class="form-group">
                        <label>Cliente:</label>
                        <p><?= $activo_data["RUC_clie"] ?></p>
                    </div>

                    <!-- Repositorios de imágenes -->
                    <div class="form-group">
                        <label>Fotos Interior/Exterior:</label>
                        <div id="gallery-interior-exterior" class="gallery-grid"></div>
                    </div>

                    <div class="form-group">
                        <label>Pruebas Técnicas:</label>
                        <div id="gallery-pruebas-tecnicas" class="gallery-grid"></div>
                    </div>

                    <div class="form-group">
                        <label>Devoluciones:</label>
                        <div id="gallery-devolucion" class="gallery-grid"></div>
                    </div>
                </div>
            </section>
        </div>
    </div>
    <?php require_once("../js/js.php"); ?>
    <script>
        function cargarGaleria(categoria, contenedorID, activoID) {
            $.get("../../controladores/anexo.php?op=listar_anexos&C_categ=" + categoria + "&Ccod_serieID=" + activoID, function(data) {
                var anexos = JSON.parse(data);
                var gallery = $("#" + contenedorID).empty();
                $.each(anexos, function(index, anexo) {
                    var rutaImagen = base_url + anexo.Cruta_hist.replace("../", "");
                    gallery.append(
                        `<div class="gallery-col">
                            <article class="gallery-item">
                                <img class="gallery-picture" src="${rutaImagen}" alt="${anexo.Cnomb_arch}" height="158">
                                <div class="gallery-hover-layout">
                                    <div class="gallery-hover-layout-in">
                                        <p class="gallery-item-title">${anexo.Cnomb_arch}</p>
                                        <p>${new Date(anexo.Dfech_crea).toLocaleDateString()}</p>
                                        <button class="btn btn-warning btn-view-full" onclick="window.open('${rutaImagen}', '_blank')">Ver en tamaño completo</button>
                                    </div>
                                </div>
                            </article>
                        </div><!--.gallery-col-->`
                    );
                });
            });
        }

        $(document).ready(function() {
            cargarGaleria('interior_exterior', 'gallery-interior-exterior', activoID);
            cargarGaleria('pruebas_tecnicas', 'gallery-pruebas-tecnicas', activoID);
            cargarGaleria('devolucion', 'gallery-devolucion', activoID);
        });
    </script>
</body>

</html>