function xorEncryptDecrypt(key, data) {
  let encrypted = "";
  for (let i = 0; i < data.length; i++) {
    encrypted += String.fromCharCode(
      data.charCodeAt(i) ^ key.charCodeAt(i % key.length)
    );
  }
  return btoa(encrypted); // Convertir a base64
}

function init() {
  // Utilizar baseURL desde el contexto de la aplicación
  var baseURL = window.baseURL;

  // Cargar los activos en el combo desplegable
  $.get(
    baseURL + "controladores/activo_cliente.php?op=listar_activos",
    function (data) {
      var activos = JSON.parse(data);
      var combo = $("#Ccod_serieID").empty();
      $.each(activos, function (index, activo) {
        combo.append(
          `<option value="${activo.Ccod_serieID}" data-serie="${activo.Ccod_serie}">${activo.Ccod_serie} - ${activo.Cdesc_Seri}</option>`
        );
      });

      // Limpiar el QR y ocultar el contenedor cuando se cambia el activo seleccionado
      combo.on("change", function () {
        $("#qr-image").attr("src", "").hide();
        $("#qr-download").hide();
        $("#qr-container").hide(); // Ocultar el contenedor del QR
      });
    }
  );

  // Asociar evento click al botón Ver Activo
  $("#btnVerActivo")
    .off("click")
    .on("click", function () {
      var Ccod_serieID = $("#Ccod_serieID").val();
      if (Ccod_serieID) {
        var key = "@457657#$878QQQ@"; // Utiliza una clave segura
        var encryptedID = xorEncryptDecrypt(key, Ccod_serieID);
        window.location.href = `${baseURL}vistas/activo_cliente/ver_activo_cliente.php?id=${encodeURIComponent(
          encryptedID
        )}`;
      }
    });

  // Asociar evento click al botón Generar QR
  $("#btnGenerarQR")
    .off("click")
    .on("click", function () {
      generarQR();
    });
}

// Función para generar o verificar QR
function generarQR() {
  var Ccod_serieID = $("#Ccod_serieID").val();
  var Ccod_serie = $("#Ccod_serieID option:selected").data("serie"); // Obtener el nombre del activo
  if (Ccod_serieID) {
    // Verificar si ya existe un QR generado
    $.post(
      baseURL + "controladores/activo_cliente.php?op=verificar_qr",
      { Ccod_serie: Ccod_serie },
      function (data) {
        var result = JSON.parse(data);
        if (result.status === "exists") {
          // Mostrar el QR existente
          $("#qr-image").attr("src", result.qr_path).show();
          $("#qr-download")
            .attr("href", result.qr_path)
            .attr("download", result.filename)
            .show();
          $("#qr-container").show();
        } else {
          // Generar un nuevo QR si no existe
          var key = "@457657#$878QQQ@"; // Utiliza la misma clave segura
          var encryptedID = xorEncryptDecrypt(key, Ccod_serieID);
          var url = `${baseURL}vistas/activo_cliente/ver_activo_cliente.php?id=${encodeURIComponent(
            encryptedID
          )}`;
          $.post(
            baseURL + "controladores/activo_cliente.php?op=generar_qr",
            { url: url, Ccod_serie: Ccod_serie },
            function (data) {
              var result = JSON.parse(data);
              if (result.status === "success") {
                $("#qr-image").attr("src", result.qr_path).show();
                $("#qr-download")
                  .attr("href", result.qr_path)
                  .attr("download", result.filename)
                  .show();
                $("#qr-container").show();
              } else {
                alert("Error al generar el QR.");
              }
            }
          );
        }
      }
    );
  }
}

$(document).ready(function () {
  init();
});
