<?php
class Usuario extends Conectar
{
    private $login_attempts = 3;
    private $lockout_time = 1 * 60; // 1 minuto

    public function login($usercod, $pass)
    {
        $conectar = parent::Conexion();
        parent::set_names();

        // Control de intentos de inicio de sesión
        $login_failed_key = 'login_failed_' . $usercod;
        $lockout_key = 'lockout_' . $usercod;

        if (isset($_SESSION[$lockout_key]) && time() < $_SESSION[$lockout_key]) {
            $_SESSION['login_error'] = "Demasiados intentos fallidos. Intente de nuevo en unos minutos.";
            header("Location: " . Conectar::ruta() . "index.php");
            exit();
        }

        $sql = "SELECT usuario.Ccod_usuID, usuario.Ccod_usu, usuario.Nom_usu, usuario.Apell_usu,
                        usuario.Pass_usu, usuario.N_rolID, rol.Sdescrip AS rol_nombre, usuario.Cusuest
                FROM usuario
                LEFT JOIN rol ON usuario.N_rolID = rol.N_rolID
                WHERE usuario.Ccod_usu = ?";

        $stmt = $conectar->prepare($sql);
        $stmt->bindValue(1, $usercod);
        $stmt->execute();
        $resultado = $stmt->fetch(PDO::FETCH_ASSOC);

        if ($resultado) {
            if ($resultado['Cusuest'] == 1) {
                if (password_verify($pass, $resultado['Pass_usu'])) {
                    session_regenerate_id(true); // Regenerar ID de sesión al iniciar sesión

                    $_SESSION["Ccod_usuID"] = $resultado["Ccod_usuID"];
                    $_SESSION["Ccod_usu"] = $resultado["Ccod_usu"];
                    $_SESSION["Nom_usu"] = $resultado["Nom_usu"];
                    $_SESSION["Apell_usu"] = $resultado["Apell_usu"];
                    $_SESSION["N_rolID"] = $resultado["N_rolID"];
                    $_SESSION["Sdescrip"] = $resultado["rol_nombre"];

                    // Resetear contador de intentos fallidos
                    unset($_SESSION[$login_failed_key], $_SESSION[$lockout_key]);

                    header("Location: " . Conectar::ruta() . "vistas/home/home.php");
                    exit();
                } else {
                    $_SESSION[$login_failed_key] = ($_SESSION[$login_failed_key] ?? 0) + 1;

                    if ($_SESSION[$login_failed_key] >= $this->login_attempts) {
                        $_SESSION[$lockout_key] = time() + $this->lockout_time;
                    }

                    $_SESSION['login_error'] = "Nombre de usuario o contraseña incorrectos.";
                }
            } else {
                $_SESSION['login_error'] = "Este usuario está desactivado. Por favor, contacte al equipo de TI.";
            }
        } else {
            $_SESSION['login_error'] = "Nombre de usuario o contraseña incorrectos.";
        }

        header("Location: " . Conectar::ruta() . "index.php");
        exit();
    }



    public function get_usuario()
    {
        $conectar = parent::conexion();
        parent::set_names();
        $sql = "SELECT
               usuario.Ccod_usuID,
               usuario.Ccod_usu,
               usuario.Nom_usu,
               usuario.Apell_usu,
               usuario.Correo_usu,
               usuario.Pass_usu,
               usuario.N_rolID,
               usuario.Cusuest,
               usuario.Dfech_crea,
               usuario.Dfech_mod,
               rol.Sdescrip AS rol_nombre
            FROM 
              usuario 
            INNER JOIN
            rol ON usuario.N_rolID = rol.N_rolID;";
        $stmt = $conectar->prepare($sql);
        $stmt->execute();
        return $stmt->fetchAll();
    }

    public function get_usuario_id($Ccod_usuID)
    {
        $conectar = parent::conexion();
        parent::set_names();
        $sql = "SELECT * FROM usuario WHERE Ccod_usuID = ?";
        $stmt = $conectar->prepare($sql);
        $stmt->execute([$Ccod_usuID]);
        return $stmt->fetch();
    }

    public function get_roles()
    {
        $conectar = parent::conexion();
        parent::set_names();
        $sql = "SELECT * FROM rol";
        $stmt = $conectar->prepare($sql);
        $stmt->execute();
        return $stmt->fetchAll();
    }

    public function insert_usuario($Ccod_usu, $Nom_usu, $Apell_usu, $Correo_usu, $Pass_usu, $N_rolID)
    {
        try {
            $conectar = parent::conexion(); // Asegúrate de usar la misma capitalización
            parent::set_names();

            $hashed_password = password_hash($Pass_usu, PASSWORD_ARGON2ID);

            $sql = "INSERT INTO usuario (Ccod_usu, Nom_usu, Apell_usu, Correo_usu, Pass_usu, N_rolID, Cusuest) 
                    VALUES (?, ?, ?, ?, ?, ?, 1)";
            $stmt = $conectar->prepare($sql);
            $result = $stmt->execute([$Ccod_usu, $Nom_usu, $Apell_usu, $Correo_usu, $hashed_password, $N_rolID]);

            return $result; // Devuelve el resultado de la ejecución para confirmar éxito
        } catch (PDOException $e) {
            // Manejo de error
            error_log("Error al insertar usuario: " . $e->getMessage());
            return false;
        }
    }

    public function update_usuario($Ccod_usuID, $Ccod_usu, $Nom_usu, $Apell_usu, $Correo_usu, $Pass_usu, $N_rolID, $Cusuest)
    {
        try {
            $conectar = parent::conexion();
            parent::set_names();

            $usuario = $this->get_usuario_id($Ccod_usuID);

            // Verificar si la contraseña ha cambiado y debe ser actualizada
            // Si el campo de la contraseña está vacío, mantener la contraseña actual
            if (empty($Pass_usu)) {
                $hashed_password = $usuario['Pass_usu']; // Mantiene la contraseña existente si no se ha cambiado
            } else {
                // Generar un nuevo hash solo si la contraseña es diferente
                $hashed_password = password_hash($Pass_usu, PASSWORD_ARGON2ID);
            }

            $sql = "UPDATE usuario 
                    SET Ccod_usu = ?, Nom_usu = ?, Apell_usu = ?, Correo_usu = ?, Pass_usu = ?, N_rolID = ?, Cusuest = ? 
                    WHERE Ccod_usuID = ?";
            $stmt = $conectar->prepare($sql);
            $result = $stmt->execute([$Ccod_usu, $Nom_usu, $Apell_usu, $Correo_usu, $hashed_password, $N_rolID, $Cusuest, $Ccod_usuID]);

            return $result; // Devuelve el resultado de la ejecución para confirmar éxito
        } catch (PDOException $e) {
            // Manejo de error
            error_log("Error al actualizar usuario: " . $e->getMessage());
            return false;
        }
    }
}
