<?php
require_once("../config/conexion.php");
require_once("../modelos/Tipoactivo.php");
require_once("../config/config.php");

$tipoactivo = new Tipoactivo();

switch ($_GET["op"]) {
    case "listar":
        $datos = $tipoactivo->listar();
        $data = [];
        foreach ($datos as $row) {
            $sub_array = [];
            $sub_array[] = $row["Ccod_tipo_act"];
            $sub_array[] = $row["Cdes_tipo_act"];
            // Utiliza $base_url para generar la URL completa del PDF
            $sub_array[] = '<a href="' . $base_url . $row["Cruta_act"] . '" target="_blank">Ver PDF</a>';
            $sub_array[] = '<button type="button" onClick="editar(' . $row["Ccod_tipo_actID"] . ');" id="' . $row["Ccod_tipo_actID"] . '" class="btn btn-info btn-sm"><i class="fa fa-edit"></i></button>';
            $data[] = $sub_array;
        }
        $results = [
            "sEcho" => 1,
            "iTotalRecords" => count($data),
            "iTotalDisplayRecords" => count($data),
            "aaData" => $data
        ];
        echo json_encode($results);
        break;

    case "mostrar":
        $datos = $tipoactivo->mostrar($_POST["Ccod_tipo_actID"]);
        echo json_encode($datos);
        break;

    case "guardaryeditar":
        $pdf = subir_pdf();

        if (empty($_POST["Ccod_tipo_actID"])) {
            $tipoactivo->insertar($_POST["Ccod_tipo_act"], $_POST["Cdes_tipo_act"], $pdf);
            echo json_encode(["status" => "success", "message" => "Tipo de activo creado correctamente."]);
        } else {
            $tipo_activo_actual = $tipoactivo->mostrar($_POST["Ccod_tipo_actID"]);
            $ruta_pdf_actual = $tipo_activo_actual["Cruta_act"];

            if ($pdf === false) {
                $pdf = $ruta_pdf_actual;
            } else {
                if (!empty($ruta_pdf_actual) && file_exists("../" . $ruta_pdf_actual)) {
                    unlink("../" . $ruta_pdf_actual);
                }
            }

            $tipoactivo->editar($_POST["Ccod_tipo_actID"], $_POST["Ccod_tipo_act"], $_POST["Cdes_tipo_act"], $pdf);
            echo json_encode(["status" => "success", "message" => "Tipo de activo actualizado correctamente."]);
        }
        break;

    case "eliminar":
        $tipo_activo_actual = $tipoactivo->mostrar($_POST["Ccod_tipo_actID"]);
        $ruta_pdf_actual = $tipo_activo_actual["Cruta_act"];

        $tipoactivo->eliminar($_POST["Ccod_tipo_actID"]);

        if (!empty($ruta_pdf_actual) && file_exists("../" . $ruta_pdf_actual)) {
            unlink("../" . $ruta_pdf_actual);
        }

        echo json_encode(["status" => "success", "message" => "Tipo de activo eliminado correctamente."]);
        break;
}

// Función para manejar la subida de PDF
function subir_pdf()
{
    if (isset($_FILES["Cruta_act"]["name"]) && $_FILES["Cruta_act"]["error"] == UPLOAD_ERR_OK) {
        $original_name = $_FILES["Cruta_act"]["name"];
        $file_type = $_FILES["Cruta_act"]["type"];

        // Validar que el archivo es un PDF
        if ($file_type !== 'application/pdf') {
            return false;
        }

        // Generar un nombre único para evitar conflictos
        $unique_name = uniqid() . '-' . $original_name;
        $target_dir = "../publico/PDF/";  // Ruta relativa a la carpeta actual
        $destination = $target_dir . $unique_name;

        // Mover el archivo al directorio de destino
        if (move_uploaded_file($_FILES["Cruta_act"]["tmp_name"], $destination)) {
            // Devolver la ruta relativa para guardarla en la base de datos
            return 'publico/PDF/' . $unique_name;
        } else {
            return false; // Error al mover el archivo
        }
    }
    return false; // No se proporcionó un archivo o hubo un error al subir
}
