<?php
require_once("../config/conexion.php");
require_once("../modelos/Anexo.php");

$anexo = new AnexoArchivos();

switch ($_GET["op"]) {
    case "listar_activos":
        $datos = $anexo->get_activos();
        echo json_encode($datos);
        break;

    case "listar_categorias":
        $datos = $anexo->get_categorias();
        echo json_encode($datos);
        break;

    case "insertar":
        $Ccod_serieID = $_POST["Ccod_serieID_modal"];
        $C_categ = $_POST["C_categ"];
        $Cnomb_arch = $_POST['Cnomb_arch']; // Obtener el nombre editado del archivo

        if (empty($Ccod_serieID) || empty($C_categ)) {
            echo json_encode(["status" => "error", "message" => "ID de activo o categoría no proporcionada."]);
            exit;
        }

        $Ccod_usuID = $_SESSION["Ccod_usuID"] ?? $anexo->get_usuario_id_por_codigo($_SESSION["Ccod_usu"]);
        $Cruta_hist = '';

        if (!empty($_FILES['file']['name'])) {
            $target_dir = '';

            switch ($C_categ) {
                case 'interior_exterior':
                    $target_dir = "../publico/img/fotos_int_ext/";
                    break;
                case 'pruebas_tecnicas':
                    $target_dir = "../publico/img/prue_tec/";
                    break;
                case 'devolucion':
                    $target_dir = "../publico/img/devol/";
                    break;
                case 'Imagen QR':
                    $target_dir = "../publico/img/QR/";
                    break;
            }

            $target_file = $target_dir . $Cnomb_arch;

            if (move_uploaded_file($_FILES["file"]["tmp_name"], $target_file)) {
                $Cruta_hist = $target_file;
                $anexo->insertar($Ccod_serieID, $Ccod_usuID, $Cruta_hist, $Cnomb_arch, $C_categ);
                echo json_encode(["status" => "success"]);
            } else {
                echo json_encode(["status" => "error", "message" => "Error al mover el archivo."]);
            }
        } else {
            echo json_encode(["status" => "error", "message" => "No se proporcionó un archivo."]);
        }
        break;

    case "listar_anexos":
        $C_categ = $_GET["C_categ"];
        $Ccod_serieID = $_GET["Ccod_serieID"];
        if (empty($C_categ) || empty($Ccod_serieID)) {
            echo json_encode(["status" => "error", "message" => "Categoría o ID de activo no proporcionados."]);
            exit;
        }
        $datos = $anexo->get_anexos_por_categoria_y_activo($C_categ, $Ccod_serieID);
        echo json_encode($datos);
        break;

    case "descargar":
        $Historial_ID = $_GET['id'];
        $ruta_archivo = $anexo->obtener_ruta_archivo($Historial_ID);
        if (file_exists($ruta_archivo)) {
            header('Content-Description: File Transfer');
            header('Content-Type: application/octet-stream');
            header('Content-Disposition: attachment; filename=' . basename($ruta_archivo));
            header('Expires: 0');
            header('Cache-Control: must-revalidate');
            header('Pragma: public');
            header('Content-Length: ' . filesize($ruta_archivo));
            readfile($ruta_archivo);
            exit;
        } else {
            echo json_encode(["status" => "error", "message" => "El archivo no existe."]);
        }
        break;

    case "eliminar":
        $Historial_ID = $_POST['id'];
        $ruta_archivo = $anexo->obtener_ruta_archivo($Historial_ID);
        if ($anexo->eliminar($Historial_ID)) {
            // Habilitar unlink por si se quiere borrar las fotos del directorio.
            // if (file_exists($ruta_archivo)) {
            //     unlink($ruta_archivo);
            // }
            echo json_encode(["status" => "success"]);
        } else {
            echo json_encode(["status" => "error", "message" => "No se pudo eliminar el registro."]);
        }
        break;
}
