<?php
require_once("../config/conexion.php");
require_once("../config/config.php");
require_once("../modelos/ActivoCliente.php");
require_once("../publico/phpqrcode/phpqrcode.php");


$activoCliente = new ActivoCliente();

switch ($_GET["op"]) {
    case "listar_activos":
        $datos = $activoCliente->get_activos();
        echo json_encode($datos);
        break;

    case "mostrar_activo":
        if (isset($_GET["Ccod_serieID"])) {
            $datos = $activoCliente->get_activo_detalle($_GET["Ccod_serieID"]);
            echo json_encode($datos);
        }
        break;

    case "verificar_qr":
        if (isset($_POST['Ccod_serie'])) {
            $Ccod_serie = $_POST['Ccod_serie'];
            $filename = "../publico/qrgenerado/" . $Ccod_serie . ".png";

            if (file_exists($filename)) {
                $public_path = $base_url . "publico/qrgenerado/" . $Ccod_serie . ".png";
                echo json_encode(["status" => "exists", "qr_path" => $public_path, "filename" => $Ccod_serie . ".png"]);
            } else {
                echo json_encode(["status" => "not_exists"]);
            }
        }
        break;

    case "generar_qr":
        if (isset($_POST['url']) && isset($_POST['Ccod_serie'])) {
            $url = $_POST['url'];
            $Ccod_serie = $_POST['Ccod_serie'];
            $filename = "../publico/qrgenerado/" . $Ccod_serie . ".png";
            $public_path = $base_url . "publico/qrgenerado/" . $Ccod_serie . ".png";

            // Generar el QR solo si no existe
            if (!file_exists($filename)) {
                QRcode::png($url, $filename, QR_ECLEVEL_L, 10);
            }

            // Verificar si el archivo se generó o ya existía
            if (file_exists($filename)) {
                echo json_encode(["status" => "success", "qr_path" => $public_path, "filename" => $Ccod_serie . ".png"]);
            } else {
                echo json_encode(["status" => "error", "message" => "No se pudo generar el QR."]);
            }
        } else {
            echo json_encode(["status" => "error", "message" => "No se proporcionó la URL o Ccod_serie."]);
        }
        break;


    case "descargar":
        $Historial_ID = $_GET['id'];
        $ruta_archivo = $anexo->obtener_ruta_archivo($Historial_ID);
        if (file_exists($ruta_archivo)) {
            header('Content-Description: File Transfer');
            header('Content-Type: application/octet-stream');
            header('Content-Disposition: attachment; filename=' . basename($ruta_archivo));
            header('Expires: 0');
            header('Cache-Control: must-revalidate');
            header('Pragma: public');
            header('Content-Length: ' . filesize($ruta_archivo));
            readfile($ruta_archivo);
            exit;
        } else {
            echo json_encode(["status" => "error", "message" => "El archivo no existe."]);
        }
        break;
}
