<?php
require_once("../config/conexion.php");
require_once("../modelos/Activo.php");
require_once("../modelos/Ubicacion.php");

$activo = new Activo();
$ubicacion = new Ubicacion();

switch ($_GET["op"]) {
    case "listar":
        $datos = $activo->get_activos();
        $data = [];
        foreach ($datos as $row) {
            $sub_array = [];
            $sub_array[] = $row["Ccod_serie"];
            $sub_array[] = $row["Cdesc_Seri"];
            $sub_array[] = $row["Cdescrip"];
            $sub_array[] = $row["RUC_clie"] ?: 'Cliente no asignado';
            $sub_array[] = $row["Edescrip"];
            $sub_array[] = $row["Ccod_tipo_act"];
            $sub_array[] = $row["Sdesc_centro"] ?: 'Sin asignar';
            $sub_array[] = $row["Cdes_zona"] ?: 'Sin asignar';
            $sub_array[] = $row["Dult_ret"];
            $sub_array[] = $row["Dult_desp"];
            $sub_array[] = $row["Dult_mnt"];
            $sub_array[] = $row["Dult_rep"];
            $sub_array[] = $row["Stiem_ant"];
            $sub_array[] = '<a href="ver_activo.php?Ccod_serieID=' . $row["Ccod_serieID"] . '" class="btn btn-info btn-sm">Ver</a>';
            $sub_array[] = '<button type="button" onClick="editar(' . $row["Ccod_serieID"] . ');" id="' . $row["Ccod_serieID"] . '" class="btn btn-info btn-sm"><i class="fa fa-cogs"></i></button>';
            $data[] = $sub_array;
        }
        $results = [
            "sEcho" => 1,
            "iTotalRecords" => count($data),
            "iTotalDisplayRecords" => count($data),
            "aaData" => $data
        ];
        echo json_encode($results);
        break;

    case "guardaryeditar":
        // Definir y validar la variable Ccod_serie desde $_POST
        $Ccod_serie = isset($_POST["Ccod_serie"]) ? trim($_POST["Ccod_serie"]) : null;

        if (empty($Ccod_serie)) {
            echo json_encode(["status" => "error", "message" => "El código de serie no puede estar vacío."]);
            exit();
        }

        $Ccod_serieID = isset($_POST["Ccod_serieID"]) ? $_POST["Ccod_serieID"] : null;

        // Normaliza los valores vacíos a NULL
        $Ccod_clieID = !empty($_POST["Ccod_clieID"]) ? $_POST["Ccod_clieID"] : null;
        $Ccod_centroID = !empty($_POST["Ccod_centroID"]) ? $_POST["Ccod_centroID"] : null;
        $Ccod_zonaID = !empty($_POST["Ccod_zonaID"]) ? $_POST["Ccod_zonaID"] : null;

        // Solo verificar duplicado si es un nuevo activo (sin Ccod_serieID)
        if (empty($Ccod_serieID)) {
            // Verificar si el código de serie ya existe
            $existe = $activo->verificar_duplicado($Ccod_serie);

            if ($existe) {
                echo json_encode(["status" => "duplicate", "message" => "El código de serie ya existe."]);
                exit();
            }

            // Insertar nuevo registro
            $Ccod_serieID = $activo->insert_activo(
                $Ccod_serie,
                $_POST["Cdesc_Seri"] ?? '',
                $Ccod_clieID,
                $_POST["Ccod_matID"] ?? null,
                $_POST["Ccod_estID"] ?? null,
                $Ccod_centroID,
                $Ccod_zonaID,
                $_POST["Ccod_tipo_actID"] ?? null,
                $_POST["Dult_ret"] ?? null,
                $_POST["Dult_desp"] ?? null,
                $_POST["Dult_mnt"] ?? null,
                $_POST["Dult_rep"] ?? null,
                $_POST["Stiem_ant"] ?? null
            );
        } else {
            // Actualizar registro existente sin verificar duplicado
            $activo->update_activo(
                $Ccod_serieID,
                $Ccod_serie,
                $_POST["Cdesc_Seri"] ?? '',
                $Ccod_clieID,
                $_POST["Ccod_matID"] ?? null,
                $_POST["Ccod_estID"] ?? null,
                $Ccod_centroID,
                $Ccod_zonaID,
                $_POST["Ccod_tipo_actID"] ?? null,
                $_POST["Dult_ret"] ?? null,
                $_POST["Dult_desp"] ?? null,
                $_POST["Dult_mnt"] ?? null,
                $_POST["Dult_rep"] ?? null,
                $_POST["Stiem_ant"] ?? null
            );

            // Registrar actualización en el historial
            $ubicacion->insert_ubicacion(
                $Ccod_serieID,
                $Ccod_centroID,
                $Ccod_zonaID,
                $_SESSION["Ccod_usu"], // Usuario que realiza la modificación
                true
            );
        }
        echo json_encode(["status" => "success"]);
        break;

    case "mostrar":
        if (isset($_POST["Ccod_serieID"])) {
            $datos = $activo->get_activo_id($_POST["Ccod_serieID"]);
            if (is_array($datos) && count($datos) > 0) {
                echo json_encode($datos);
            }
        }
        break;
    case "combo_tipo_activo":
        $datos = $activo->get_tipo_activo();
        if (!empty($datos)) {
            $html = "<option value=''>-- Seleccione Tipo de Activo --</option>";
            foreach ($datos as $row) {
                $id = htmlspecialchars($row['Ccod_tipo_actID'], ENT_QUOTES, 'UTF-8');
                $codigo = htmlspecialchars($row['Ccod_tipo_act'], ENT_QUOTES, 'UTF-8');
                $descripcion = htmlspecialchars($row['Cdes_tipo_act'], ENT_QUOTES, 'UTF-8');
                $html .= "<option value='{$id}'>{$codigo} - {$descripcion}</option>";
            }
            echo $html;
        }
        break;

    case "combo_zonas_por_centro":
        if (isset($_POST["Ccod_centroID"])) {
            $datos = $activo->get_zonas_por_centro($_POST["Ccod_centroID"]);
            if (is_array($datos) && count($datos) > 0) {
                $html = "<option value=''>-- Seleccione Zona --</option>";
                foreach ($datos as $row) {
                    $html .= "<option value='" . $row['Ccod_zonaID'] . "'>" . $row['Cdes_zona'] . "</option>";
                }
                echo $html;
            }
        }
        break;


    case "combo_clientes":
        $datos = $activo->get_cliente_est();
        if (is_array($datos) && count($datos) > 0) {
            $html = "<option value=''>-- Ningún Cliente --</option>"; // Opción nula
            foreach ($datos as $row) {
                $html .= "<option value='" . $row['Ccod_clieID'] . "'>" . $row['RUC_clie'] . " - " . $row['Emp_clie'] . "</option>";
            }
            echo $html;
        }
        break;;

    case "combo_materiales":
        $datos = $activo->get_material_est();
        if (is_array($datos) == true and count($datos) > 0) {
            $html = "<option value=''>-- seleccione un material --</option>";
            foreach ($datos as $row) {
                $html .= "<option value='" . $row['Ccod_matID'] . "'>" .  $row['Ccod_mat'] . " - " . $row['Cdescrip'] . "</option>";
            }
            echo $html;
        }
        break;

    case "combo_estados":
        $datos = $activo->get_estado();
        if (is_array($datos) == true and count($datos) > 0) {
            $html = "";
            foreach ($datos as $row) {
                $html .= "<option value='" . $row['Ccod_estID'] . "'>" . $row['Edescrip'] . "</option>";
            }
            echo $html;
        }
        break;

    case "combo_zonas":
        $datos = $activo->get_zona_est();
        if (is_array($datos) == true and count($datos) > 0) {
            $html = "<option value=''>-- Ninguna Zona --</option>";
            foreach ($datos as $row) {
                $html .= "<option value='" . $row['Ccod_zonaID'] . "'>" . $row['Cdes_zona'] . "</option>";
            }
            echo $html;
        }
        break;

    case "combo_centros":
        $datos = $activo->get_centro_est();
        if (is_array($datos) == true and count($datos) > 0) {
            $html = "<option value=''>-- Ningún Centro --</option>";
            foreach ($datos as $row) {
                $html .= "<option value='" . $row['Ccod_centroID'] . "'>" . $row['Sdesc_centro'] . "</option>";
            }
            echo $html;
        }
        break;

    case "listar_anexos":
        if (isset($_GET["C_categ"]) && isset($_GET["Ccod_serieID"])) {
            $datos = $activo->get_anexos_por_categoria($_GET["Ccod_serieID"], $_GET["C_categ"]);
            echo json_encode($datos);
        }
        break;
}
